       program PE_initial
c
c=======================================================================
c                                                                    ===
c  This program generates  initial, boundary  conditions and/or      ===
c  assimilation fields for the Harvard PE model.                     ===
c                                                                    ===
c  Harvard University Oceanography Group                             ===
c  Harvard Ocean Prediction System (HOPS)                            ===
c                                                                    ===
c  Hernan G. Arango                                                  ===
c  Carlos J. Lozano                                                  ===
c  Patrick J. Haley                                                  ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <curflds.h>
#include <grddat.h>
#include <hybrid.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <oldflds.h>
#include <pi_netcdf.h>
#include <shapfil.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
       integer i,ip,iread,j,k,m,n,nrmbdy
       real c1,cm2m,day
#ifdef sunfpe
       integer ieeer,my_handler,ieee_handler
       external my_handler
#endif
       parameter(c1=1.0,cm2m=0.01)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
#ifdef sunfpe
c
c-----------------------------------------------------------------------
c  Set trap for floating point exceptions.
c-----------------------------------------------------------------------
c
      ieeer=ieee_handler('set','common',my_handler)
      if(ieeer.ne.0) print *,' IEEE_HANDLER cannot set my_handler'
#endif
c
c-----------------------------------------------------------------------
c  Read in input paramenters.
c-----------------------------------------------------------------------
c
      call get_parm
c
c-----------------------------------------------------------------------
c  Set the depths of each tracer and velocity grid point which are
c  used to interpolate fields to hybrid coordinates.
c-----------------------------------------------------------------------
c
      call setdepths
c
c-----------------------------------------------------------------------
c  Create and define netCDF file. Write out parameters and time
c  independent variables.
c-----------------------------------------------------------------------
c
      call defcdf
c
c-----------------------------------------------------------------------
c  Read in input fields: streamfunction, QG bathymetry, temperature,
c  salinity, QG vertical velocity, and error fields when available.
c-----------------------------------------------------------------------
c
  10  continue
      if(job.eq.3) then
        call get_unif (day,iread)
       else if(ifile.eq.0) then
        call get_cdfdat(day,iread)
cjad
        if(itrc.eq.1) call get_trc(day)
       else
        call get_data(day,iread)
      endif
      if(day.gt.tstop) goto 110
c
c-----------------------------------------------------------------------
c  Non-dimensionalize any dimensional errors.
c-----------------------------------------------------------------------
c
      call scale_err
c
c-----------------------------------------------------------------------
c  Compute streamfunction from T,S
c-----------------------------------------------------------------------
c
      if ((its2psi.eq.1).and.(.not.ldrctvel)) call ts2psi
c
c-----------------------------------------------------------------------
c  If requested, Shapiro filter input fields.
c-----------------------------------------------------------------------
c
      if (mod(ifilter,2).eq.1) then
        do 30 k=1,kfld
        do 30 n=1,nrep
          call filter (psi(1,k),im,im,jm,nord)
          do 20 m=1,nt
            call filter (t(1,k,m),im,im,jm,nord)
  20      continue
  30    continue
      endif
c
c-----------------------------------------------------------------------
c  Set reference surface for streamfunction.
c-----------------------------------------------------------------------
c
      if ((job.ne.3).and.((iflag(5)/4).gt.0).and.(.not.ldrctvel))
     &   call set_psi
c
c-----------------------------------------------------------------------
c  Calculate vertically integrated streamfunction (transport).
c-----------------------------------------------------------------------
c
      if (job.lt.2) call psibar
c
c-----------------------------------------------------------------------
c  Calculate horizontal velocity (internal and external) field and
c  interpolate to hybrid coordinates.
c-----------------------------------------------------------------------
c
      call velocity
c
#ifdef meantracer
c-----------------------------------------------------------------------
c  Compute mean tracer fields.
c-----------------------------------------------------------------------
c
      call set_meantrc
c
#endif
c-----------------------------------------------------------------------
c  Interpolate tracers to terrain-following coordinates.
c-----------------------------------------------------------------------
c
      do 50 n=1,nt
        call interp(t(1,1,n),depthmt,zfld,kfld,intopt)
        call interp(tmean(1,1,n),depthmt,zfld,kfld,intopt)
  50  continue
c
c-----------------------------------------------------------------------
c  If no data was provided for additional tracers, set them to unity.
c-----------------------------------------------------------------------
c
      if ((itrc.eq.0).and.(nt.gt.2)) then
        do 90 m=3,nt
        do 90 k=1,km
        do 90 j=1,jm
        do 90 i=1,im
          ip=i+(j-1)*im
          t(ip,k,m)=c1
  90    continue
      endif
c
c-----------------------------------------------------------------------
c  Write out initial conditions or assimilation fields.
c-----------------------------------------------------------------------
c
      if(initial.eq.0) then
        call put_init
        if(job.ne.1) initial=1
      endif
c
c-----------------------------------------------------------------------
c  Write out boundary information.
c-----------------------------------------------------------------------
c
 100  if((job.ne.1).and.(ncall.gt.0)) then
        do 105 nrmbdy = 1, 3
          call put_bry (nrmbdy)
 105    continue
      endif
      ncall=ncall+1
c
c-----------------------------------------------------------------------
c  Swap the data from new to old in order to compute the time rate
c  of change of vorticity at the boundary.
c-----------------------------------------------------------------------
c
      if((job.ne.1).and.(.not.last)) then
        call swapdata
        if(day.eq.tstop) then
          last=.true.
          iread=1
          goto 100
        endif
      endif
c
c-----------------------------------------------------------------------
c  Read and process fields for next time, if applicable.
c-----------------------------------------------------------------------
c
      if(iread.eq.0) goto 10
 110  continue
      call exitus('PE_INITIAL DONE')
      stop
      end
