      block data blkdat
c
c=======================================================================
c                                                                    ===
c  Sub-program to initialize some variables and arrays in named      ===
c  common blocks  (preferred method of some FORTRAN compiliers).     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <qgfldid.h>
#include <iounits.h>
#include <cstseg.h>
#include <pefldid.h>
#include <pi_netcdf.h>
#include <switches.h>
#include <version.h>
c
c=======================================================================
c  Initialize some common block data.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Set the model name, closing date of current version & version number.
c-----------------------------------------------------------------------
c
      data model /'PE_INITIAL'/
      data vdate /'06/23/2005'/
      data vnum  /'9.11      '/
c
c-----------------------------------------------------------------------
c  Intialize internal counters and switches.
c-----------------------------------------------------------------------
c
      data initial /0/
      data ncall /0/
      data last /.false./
      data ldrctvel /.false./
      data ifpers /0/
      data tindx /0/
c
c-----------------------------------------------------------------------
c  Set IO units.
c-----------------------------------------------------------------------
c
      data stdinp /5/
      data stdout /6/
      data hexinp /7/
      data islinp /10/
      data mtsinp /11/
      data trcinp /12/
      data extinp /13/
c
c-----------------------------------------------------------------------
c  Initialize PE/PE_INITIAL internal flags.
c-----------------------------------------------------------------------
c
      data iflag /6*0,1,3*0/
c
c-----------------------------------------------------------------------
c  Initialize observation error switches to inactive state.
c-----------------------------------------------------------------------
c
      data lwrtoerr /.false./
      data ioerr /21*0/
c
c-----------------------------------------------------------------------
c  Initialize error rescaling switches to inactive state.
c-----------------------------------------------------------------------
c
      data ioscl /21*0/
c
c-----------------------------------------------------------------------
c  Initialize status flags for netCDF files to "closed".
c-----------------------------------------------------------------------
c
      data ncinpfl,ncgrdfl,ncoutfl,ncsnmfl /4*0/
c
c-----------------------------------------------------------------------
c  Initialize land masks to "no land".
c-----------------------------------------------------------------------
c
      data icoast,nseg,nisle /3*0/
      data landt  /np*1/
      data ismask /np*0/
c
c-----------------------------------------------------------------------
c  Initialize NetCDF names of tracer variables.
c-----------------------------------------------------------------------
c
      data tname(1,1) /'temp                                        '/
      data tname(2,1) /'temperature                                 '/
      data tname(3,1) /'Celsius                                     '/
      data tname(4,1) /'temperature, scalar                         '/
      data tname(1,2) /'salt                                        '/
      data tname(2,2) /'salinity                                    '/
      data tname(3,2) /'PSU                                         '/
      data tname(4,2) /'salinity, scalar                            '/
#ifdef bioDuse
      data tname(1,izoo) /'zoo                                      '/
      data tname(2,izoo) /'zooplankton concentraction               '/
      data tname(3,izoo) /'millimoles nitrogen meter-3              '/
      data tname(4,izoo) /'zooplankton, scalar, series              '/
      data tname(1,ino3) /'NO3                                      '/
      data tname(2,ino3) /'nitrate concentraction                   '/
      data tname(3,ino3) /'millimoles nitrogen meter-3              '/
      data tname(4,ino3) /'nitrate, scalar, series                  '/
      data tname(1,inh4) /'NH4                                      '/
      data tname(2,inh4) /'ammonium concentraction                  '/
      data tname(3,inh4) /'millimoles nitrogen meter-3              '/
      data tname(4,inh4) /'ammonium, scalar, series                 '/ 
      data tname(1,idet) /'detritus                                 '/
      data tname(2,idet) /'detritus concentration                   '/
      data tname(3,idet) /'millimoles nitrogen meter-3              '/
      data tname(4,idet) /'detritus, scalar, series                 '/  
      data tname(1,iqn3) /'CELLNO3                                  '/
      data tname(2,iqn3) /'cellular nitrogen (from nitrate)         '/
      data tname(3,iqn3) /'millimoles nitrogen meter-3              '/
      data tname(4,iqn3) /'cellnitrate, scalar, series              '/
      data tname(1,iqn4) /'CELLNH4                                  '/
      data tname(2,iqn4) /'cellular nitrogen (from ammonia)         '/
      data tname(3,iqn4) /'millimoles nitrogen meter-3              '/
      data tname(4,iqn4) /'cellammonia, scalar, series              '/
      data tname(1,ichl) /'CHL                                      '/
      data tname(2,ichl) /'chlorophyll concentration                '/
      data tname(3,ichl) /'milligrams meter-3                       '/
      data tname(4,ichl) /'chlorophyll, scalar, series              '/
#else
      data tname(1,3) /'phyto                                       '/
      data tname(2,3) /'phytoplankton concentraction                '/
      data tname(3,3) /'millimoles nitrogen meter-3                 '/
      data tname(4,3) /'phytoplankton, scalar                       '/
      data tname(1,4) /'zoo                                         '/
      data tname(2,4) /'zooplankton concentraction                  '/
      data tname(3,4) /'millimoles nitrogen meter-3                 '/
      data tname(4,4) /'zooplankton, scalar                         '/
      data tname(1,5) /'NO3                                         '/
      data tname(2,5) /'nitrate concentraction                      '/
      data tname(3,5) /'millimoles nitrogen meter-3                 '/
      data tname(4,5) /'nitrate, scalar                             '/
      data tname(1,6) /'NH4                                         '/
      data tname(2,6) /'ammonium concentraction                     '/
      data tname(3,6) /'millimoles nitrogen meter-3                 '/
      data tname(4,6) /'ammonium, scalar                            '/
      data tname(1,7) /'PON                                         '/
      data tname(2,7) /'particulate organic nitrogen concentraction '/
      data tname(3,7) /'millimoles nitrogen meter-3                 '/
      data tname(4,7) /'PON, scalar                                 '/
      data tname(1,8) /'DON                                         '/
      data tname(2,8) /'dissolved organic nitrogen concentraction   '/
      data tname(3,8) /'millimoles nitrogen meter-3                 '/
      data tname(4,8) /'DON, scalar                                 '/
      data tname(1,9) /'bacteria                                    '/
      data tname(2,9) /'bacteria concentraction                     '/
      data tname(3,9) /'millimoles nitrogen meter-3                 '/
      data tname(4,9) /'bacteria, scalar                            '/
#endif
c
c-----------------------------------------------------------------------
c  Initialize identifications numbers of tracer and tracer error fields.
c-----------------------------------------------------------------------
c
c  Diagnostic printing
c
#ifdef bioDuse
      data tid    /petemp,pesalt,petrc3,petrc4,petrc5,petrc6,petrc7,
     *             petrc8,petrc9/
      data toerid /petoer,pesoer,pet3oe,pet4oe,pet5oe,pet6oe,pet7oe,
     *             pet8oe,pet9oe/
      data tferid /petfer,pesfer,pet3fe,pet4fe,pet5fe,pet6fe,pet7fe,
     *             pet8fe,pet9fe/
#else
      data tid    /petemp,pesalt,petrc1,petrc2,petrc3,petrc4,petrc5/
      data toerid /petoer,pesoer,pet1oe,pet2oe,pet3oe,pet4oe,pet5oe/
      data tferid /petfer,pesfer,pet1fe,pet2fe,pet3fe,pet4fe,pet5fe/
#endif
c
c  Hexadecimal input
c
#ifdef bioDuse
      data trcid    /qgtemp,qgsalt,petrc3,petrc4,petrc5,petrc6,petrc7,
     *               petrc8,petrc9/
      data trcerrid /qgtoer,qgsoer,pet3oe,pet4oe,pet5oe,pet6oe,pet7oe,
     *               pet8oe,pet9oe/
#else
      data trcid    /qgtemp,qgsalt,30,31,32,33,34,35,36/
      data trcerrid /qgtoer,qgsoer,130,131,132,133,134,135,136/
#endif
c
      end
