      subroutine errlim (errfld,nk)
c
c=======================================================================
c                                                                    ===
c  This routine ensures that the errors are bounded between 0 and 1. ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     ERRFLD   Original error field.       (real array)              ===
c     NK       Number of vertical levels.  (integer)                 ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c     IM   number of points in the x-direction.  (integer)           ===
c     JM   number of points in the y-direction.  (integer)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     ERRFLD   Bounded error field.        (real array)              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <ndimen.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ip,k,nk
      real    c0,c1
      real errfld(np,nk)
c
      parameter (c0=0.0, c1=1.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 20 k = 1, nk
         do 10 ip = 1, im*jm
            errfld(ip,k)=max(c0,min(c1,errfld(ip,k)))
  10     continue
  20  continue
c
      return
      end
