      subroutine setvgd (nx,ny,tfld,vfld)
c
c=======================================================================
c                                                                    ===
c  This routine constructs a field over velocity grid points based   ===
c  on the equivalent field over tracer grid points.                  ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NX     Number of points in x-direction.   (integer)            ===
c     NY     Number of points in y-direction.   (integer)            ===
c     TFLD   Field over tracer grid points.     (real array)         ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     VFLD   Field over velocity grid points.   (real array)         ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     none                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,nx,nxm1,ny,nym1
      real    tfld(nx,ny),vfld(nx,ny)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      nxm1 = nx - 1
      nym1 = ny - 1
c
      do 20 j = 1, nym1
         do 10 i = 1, nxm1
            vfld(i,j) = p25*(tfld(i,j)+tfld(i+1,j)+tfld(i,j+1)+
     &                       tfld(i+1,j+1))
  10     continue
         vfld(nx,j) = p5*(tfld(nx,j)+tfld(nx,j+1))
  20  continue
c
      do 30 i = 1, nxm1
         vfld(i,ny) = p5*(tfld(i,ny)+tfld(i+1,ny))
  30  continue
c
      vfld(nx,ny) = p5*(vfld(nx,nym1)+vfld(nxm1,ny))
c
      return
      end
