c
c=======================================================================
c  Include file "pi_netcdf.h".
c=======================================================================
#ifndef rmdocinc
c
c  Generic NetCDF variables:
c 
c  ATTYPE    attribute type.
c  DIMNAM    dimension name.
c  LTYPE     length of character string TYPE.
c  NCINPID   NetCDF ID for input file.
c  NCINPFL   Flag for state of NetCDF input file.
c  NCGRDID   NetCDF ID for GRIDS file.
c  NCGRDFL   Flag for state of NetCDF GRIDS file
c  NCOUTID   NetCDF ID for output file.
c  NCOUTFL   Flag for state of NetCDF output file.
c  NCSNMID   NetCDF ID for reference surface input file.
c  NCSNMFL   Flag for state of NetCDF reference surface input file.
c  NDIMS     number of defined dimensions.
c  NTIME     number of time levels in unlimited dimension time.
c  NVATTS    number of variable attributes for current variable.
c  NVDIMS    number of dimensions for current variable.
c  NGATTS    number of global attributes.
c  NVARS     number of defined variables.
c  RCODE     netCDF returned error code (0 for no errors).
c  RECDIM    ID of the unlimited dimension.
c  TYPE      input NetCDF file type or origin.
c  TIME      values of unlimited dimension TIME.
c  VARID     generic ID for arbitrary variables.
c  VARNAM    variable name.
c  VARTYP    selected netCDF data type (NCFLOAT or NCDOUBLE).
c  VDIMS     IDs of the dimension for all variables.
c
c  IDs for output NetCDF dimensions and variables:
c
c  BPTSDIM   maximum number of boundary points dimension.
c  BRYDIM    boundary edge dimension.
c  BYNMDM    width extended BC data normal to the boundary.
c  CSEGXID   coastal segment x-index coordinate.
c  CSEGYID   coastal segment y-index coordinate.
c  CSTDIM    dimension vector for coastal segments.
c  EMAXID    maximum observation error value per field type.
c  EMINID    minimum observation error value per field type.
c  FDIM      dimension vector for observation error range.
c  FLDDIM    number of primitive fields dimension.
c  GB2DIM    dimension vector for 2D boundary positions.
c  GB3DIM    dimension vector for 3D boundary positions.
c  IEISID    ending x-index coordinate of island box.
c  ISISID    starting x-index coordinate of island box.
c  ISLEDIM   number of islands dimension.
c  JEISID    ending y-index coordinate of island box.
c  JSISID    starting y-index coordinate of island box.
c  LANDTID   land/sea mask at tracer points.
c  LANDVID   land/sea mask at velocity points.
c  LCSEGDIM  maximum length of coastal segments dimension.
c  LEVDIM    level dimension.
c  LVLDIM    original flat level dimension.
c  LEVID     model vertical levels.
c  NCSEGDIM  number of coastal segements dimension.
c  NTRCDIM   number of tracers dimension.
c  PBRYID    boundary, transport streamfunction.
c  PERRID    observation error, transport streamfunction.
c  PINIID    initialization, transport streamfunction.
c  POBSID    observation, transport streamfunction.
c  QBRYID    boundary, time rate of change of barotropic vorticity.
c  QG2BID    2D boundary grid positions for vorticity.
c  TBDIM     dimension vector for tracer type boundary variables.
c  TBRYID    tracer type of boundary variables.
c  TBTHID    bathymetry at tracer points.
c  TDIM      dimension vector for tracer type variables.
c  TG2BID    2D boundary grid positions of variables at tracer points.
c  TG2DID    2D grid positions of variables at tracer points.
c  TG2DIM    dimension vector for 2D positions at tracer points.
c  TG3BID    3D boundary grid positions of variables at tracer points.
c  TG3DID    3D grid positions of variables at tracer points.
c  TG3DIM    dimension vector for 3D positions at velocity points.
c  TERRID    observation error, tracer type of variables.
# ifndef gridold
c  TIFCID    coordinate interface at tracer points.
# endif
c  TIME0DIM  initialization time dimension.
c  TIMEDIM   observation time dimension.
c  TIME0ID   initialization time.
c  TIMEID    observation, time since initialization.
c  TINDX     counter for observation time dimension.
c  TINIID    initialization, tracer type of variables.
c  TLATDIM   latitude at tracer points dimension.
c  TLONDIM   longitude at tracer points dimension.
c  TMENID    mean, tracer type of variables.
c  TNAME     attributes for additional tracers (name, units, fieldname).
c  TOBSID    observation, tracer type of variables.
c  VBDIM     dimension vector for velocity type boundary variables.
c  VBA1ID    first guess barotropic velocity.
c  VBA2ID    topography adjusted guess to barotropic velocity.
c  VBARID    barotropic velocity.
c  VBRYID    boundary, internal mode velocity.
# ifndef gridold
c  VBTHID    bathymetry at velocity points.
# endif
c  VDIM      dimension vector for velocity type variables.
c  VERRID    observation error, internal mode velocity.
c  VFLTID    Geostrophic velocity on flat levels.
c  VG2DID    2D grid positions of variables at velocity points.
c  VG2DIM    dimension vector for 2D positions at velocity points.
c  VG3BID    3D boundary grid positions of variables at velocity points.
c  VG3DID    3D grid positions of variables at velocity points.
c  VG3DIM    dimension vector for 3D positions at velocity points.
c  VGEOID    Geostrophic velocity on terrain-following levels.
c  VGFLID    Flat grid horizontal positions of variables at velocity points.
# ifndef gridold
c  VIFCID    coordinate interface at velocity points.
# endif
c  VINIID    initialization, internal mode velocity.
c  VLATDIM   latitudes at velocity points dimension.
c  VLONDIM   longitudes at velocity points dimension.
c  VOBSID    observation, internal mode velocity.
c  VTOTID    total velocity.
c  ZFLTID    Depths at original flat levels
c
c=======================================================================
#endif
c
      integer east,maxtrc,maxvar,north,south,west,xindx,yindx,zindx
#ifdef bioDuse
      integer idet,inh4,ino3,izoo,iqn3,iqn4,ichl
#endif
      parameter (maxtrc=9, maxvar=100)
      parameter (west=1, south=2, east=3, north=4)
      parameter (xindx=1, yindx=2, zindx=3)
#ifdef bioDuse
      parameter (ino3=3,iqn3=4,izoo=5,inh4=6,idet=7,ichl=8,iqn4=9)
#endif
c
      integer attype,bptsdim,brydim,bynmdm,csegxid,csegyid,emaxid,
     &        eminid,flddim,ieisid,isisid,isledim,jeisid,jsisid,landtid,
     &        landvid,lcsegdim,levdim,levid,ltype,lvldim,ncinpid,
     &        ncinpfl,ncgrdid,ncgrdfl,ncoutid,ncoutfl,ncsnmid,ncsnmfl,
     &        ncsegdim,ndims,ngatts,ntime,ntrcdim,nvars,nvatts,pbryid,
     &        perrid,piniid,pobsid,qbryid,qg2bid,rcode,recdim,tbryid,
     &        tbthid,tg2bid,tg2did,tg3bid,tg3did,time0dim,timedim,
     &        time0id,timeid,tindx,tlatdim,tlondim,varid,vartyp,vba1id,
     &        vba2id,vbarid,vbryid,verrid,vfltid,vg2did,vg3bid,vg3did,
     &        vgeoid,vgflid,viniid,vlatdim,vlondim,vobsid,vtotid,zfltid
#ifndef gridold
     &        ,tifcid,vbthid,vifcid
#endif
      integer cstdim(2),fdim(3),gb2dim(4),gb3dim(5),nvdims(maxvar),
     &        tbdim(6),tdim(4),terrid(maxtrc),tg2dim(3),tg3dim(4),
     &        tiniid(maxtrc),tmenid(maxtrc),tobsid(maxtrc),vbdim(6),
     &                    vdim(5),vdims(6,maxvar),vg2dim(3),vg3dim(4)
      common /ipi_netcdf/ attype,bptsdim,brydim,bynmdm,csegxid,csegyid,
     &                    emaxid,eminid,flddim,ieisid,isisid,isledim,
     &        jeisid,jsisid,landtid,landvid,lcsegdim,levdim,levid,ltype,
     &        lvldim,ncinpid,ncinpfl,ncgrdid,ncgrdfl,ncoutid,ncoutfl,
     &        ncsnmid,ncsnmfl,ncsegdim,ndims,ngatts,ntime,ntrcdim,nvars,
     &        nvatts,pbryid,perrid,piniid,pobsid,qbryid,qg2bid,rcode,
     &        recdim,tbryid,tbthid,tg2bid,tg2did,tg3bid,tg3did,time0dim,
     &        timedim,time0id,timeid,tindx,tlatdim,tlondim,varid,vartyp,
     &        vba1id,vba2id,vbarid,vbryid,verrid,vfltid,vg2did,vg3bid,
     &        vg3did,vgeoid,vgflid,viniid,vlatdim,vlondim,vobsid,vtotid,
     &        zfltid,cstdim,fdim,gb2dim,gb3dim,nvdims,tbdim,tdim,terrid,
     &        tg2dim,tg3dim,tiniid,tmenid,tobsid,vbdim,vdim,vdims,
     &        vg2dim,vg3dim
#ifndef gridold
     &        ,tifcid,vbthid,vifcid
#endif
c
      real                time(maxvar)
      common /fpi_netcdf/ time
c
      character*10 dimnam
      character*20 type
      character*44        tname(4,maxtrc),varnam(maxvar)
      common /cpi_netcdf/ dimnam,type,varnam,tname
