      subroutine velocity
c
c=======================================================================
c                                                                    ===
c  This routine computes internal and external mode velocity         ===
c  components from  geostrophic  streamfunction.   It uses a         ===
c  Conjugate Gradient  algorithm  for the computation of the         ===
c  external mode streamfunction.                                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <grddat.h>
#include <hybrid.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <shapfil.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,imax,ip,j,jmax,k,n
      real c0,c1,c2,cm2m,cpsi,cenlat,cenlon,deg2cm,deg2rad,facx,facy,fx,
     &     p5,pi,rearth,scle,sumu,sumv,yoff
      real p(np),pv(np)
#ifdef gridold
     &     ,dz(nz)
#endif
      parameter (c0=0.0,c1=1.0,c2=2.0,cm2m=0.01,cpsi=1.0,p5=0.5)
      parameter(pi=3.14159 26535 89793 23846,rearth=6371.315e5,
     *           deg2rad=pi/180.0,deg2cm=deg2rad*rearth)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      write(stdout,5) dcur
   5  format(/,' Computing internal and external velocity at day = ',
     *       f12.4)
c
c  If using horizontally uniform T,S; set internal mode velocities to zero
c  and tranport streamfunction constant (zero external mode velocities).
c
      if(job.eq.3) then
        do 10 j=1,jm
        do 10 i=1,im
          ip=i+(j-1)*im
          ubar(ip)=c0
          vbar(ip)=c0
          pbar(ip)=cpsi
        do 10 k=1,km
          ui(ip,k)=c0
          vi(ip,k)=c0
  10    continue
        return
      endif
c
c  Compute velocity components U,V (cm/s) from quasi-geostrophic
c  streamfunction (PSI) centered on T-S points in a B-grid.
c
      if (.not.ldrctvel) then
         facx=p5*v0*dhor/dx
         facy=p5*v0*dhor/dy
         scle=c1
         call xy2ll (p5*float(im+1),p5*float(jm+1),coord,im,jm,dx,dy,
     *               rlng0,rlat0,delx,dely,thetad,cenlon,cenlat)
         if (iflag(6).eq.3) fx=sin(cenlat*deg2rad)
c
         do 60 k=1,kfld
           do 30 j=1,jm-1
             do 20 i=1,im-1
               ip=i+(j-1)*im
               if (iflag(6).eq.2) then
                  yoff=(geolat(ip)-cenlat)*deg2cm
                  scle=f0/(f0+beta*yoff)
                 elseif (iflag(6).eq.3) then
                  scle=fx/sin(geolat(ip)*deg2rad)
               endif
               u(ip,k)=scle*facy*((psi(ip,k)-psi(ip+im,k))+
     *                       (psi(ip+1,k)-psi(ip+im+1,k)))/vmety(ip)
               v(ip,k)=scle*facx*((psi(ip+1,k)-psi(ip,k))+
     *                       (psi(ip+im+1,k)-psi(ip+im,k)))/vmetx(ip)
  20         continue
  30       continue
           do 40 i=1,im
             ip=(jm-1)*im+i
             u(ip,k)=u(ip-im,k)+(u(ip-im,k)-u(ip-2*im,k))
             v(ip,k)=v(ip-im,k)+(v(ip-im,k)-v(ip-2*im,k))
  40       continue
           do 50 j=1,jm
             ip=j*im
             u(ip,k)=u(ip-1,k)+(u(ip-1,k)-u(ip-2,k))
             v(ip,k)=v(ip-1,k)+(v(ip-1,k)-v(ip-2,k))
  50       continue
  60     continue
      end if
c
      call putdiag ('FlatGeostrophicVelocity')
c
c  If requested, Shapiro velocity on flat levels.
c
      if (mod(ifilter,4).gt.1) then
        do 85 k=1,kfld
        do 85 n=1,nrep
          call filter (u(1,k),im,im,jm,nord)
          call filter (v(1,k),im,im,jm,nord)
  85    continue
      endif
c
c  Interpolate velocity components to hybrid coordinates.
c
      call interp (u,depthmv,zfld,kfld,intopt)
      call interp (v,depthmv,zfld,kfld,intopt)
c
      call putdiag ('InterpolatedGeostrophicVelocity')
c
c  Compute external mode velocity components (UBAR,VBAR) from
c  PE velocity.
c
      do 120 j=1,jm
        do 110 i=1,im
          sumu=c0
          sumv=c0
          ip=i+(j-1)*im
          do 100 k=1,km
#ifdef gridold
            if(k.eq.1) then
              dz(k)=c2*depthmv(ip,k)
            else
              dz(k)=c2*(depthmv(ip,k)-depthmv(ip,k-1))-dz(k-1)
            endif
            sumu=sumu+u(ip,k)*dz(k)
            sumv=sumv+v(ip,k)*dz(k)
 100      continue
          ubar(ip)=sumu/hv(ip)
          vbar(ip)=sumv/hv(ip)
#else
            sumu=sumu+u(ip,k)*dzv(ip,k)
            sumv=sumv+v(ip,k)*dzv(ip,k)
 100      continue
          ubar(ip)=sumu/hvz(ip)
          vbar(ip)=sumv/hvz(ip)
#endif
 110    continue
 120  continue
c
c  Calculate internal mode velocity.
c
      do 150 k=1,km
        do 140 j=1,jm
          do 130 i=1,im
            ip=i+(j-1)*im
            ui(ip,k)=u(ip,k)-ubar(ip)
            vi(ip,k)=v(ip,k)-vbar(ip)
 130      continue
 140    continue
 150  continue
c
c-----------------------------------------------------------------------
c  Calculate PE transport: Solve Poisson Equation.
c-----------------------------------------------------------------------
c
c  Set first guess for the transport streamfunction and boundary
c  condition for forcing term.
c
      if(job.eq.2) then
c
c  Read in external mode components
c
        read(extinp,*) imax,jmax
        if((imax.ne.im).or.(jmax.ne.jm)) then
          write(stdout,165) 'im,jm',im,jm,'imax,jmax',imax,jmax
 165      format(' VELOCITY - error reading external mode components,'
     &           /12x,'incompatible number of grid points:',
     &           2(/12x,'(',a,')=(',i4,', ',i4,')'))
          call exitus('VELOCITY')
        endif
        read(extinp,*) (ubar(ip),ip=1,imax*jmax)
        read(extinp,*) (vbar(ip),ip=1,imax*jmax)
        read(extinp,*) (p_bry(j,1),j=1,jmax),(p_bry(j,2),j=1,jmax),
     *                 (p_bry(i,3),i=1,imax),(p_bry(i,4),i=1,imax)
c
        do 180 j=1,jm
          do 170 i=1,im
            ip=i+(j-1)*im
            pbar(ip)=c0
 170      continue
 180    continue
        do 190 j=1,jm
          ip=1+(j-1)*im
          pbar(ip)=p_bry(j,1)
          ip=im+(j-1)*im
          pbar(ip)=p_bry(j,2)
 190    continue
        do 200 i=1,im
          ip=i
          pbar(ip)=p_bry(i,3)
          ip=i+(jm-1)*im
          pbar(ip)=p_bry(i,4)
 200    continue
      endif
c
      call putdiag ('FirstGuessBarotropicVelocity')
c
c-----------------------------------------------------------------------
c Add bottom steering effect to barotropic velocity if requested.
c-----------------------------------------------------------------------
c
      call set_baro (ubar,vbar)
c
      call putdiag ('BottomAdjustedBarotropicVelocity')
c
c-----------------------------------------------------------------------
c Reset vertically average streamfunction along outer boundary to
c preserve desired normal component of velocity if requested.
c-----------------------------------------------------------------------
c
      call psibdy (ubar,vbar)
c
c----------------------------------------------------------------------
c Set arrays for call to external.
c----------------------------------------------------------------------
c
      do 210 ip = 1, im*jm
          p(ip)    = pbar(ip)
          pv(ip)   = pbar(ip)
 210  continue
c
c----------------------------------------------------------------------
c  Solve for PE transport streamfunction.
c----------------------------------------------------------------------
c
      call external (p,pv)
c
      call putdiag ('BarotropicVelocity')
      call putdiag ('TotalVelocity')
c
      return
      end
