       program PE_initial
c
c=======================================================================
c                                                                    ===
c  This program generates  initial, boundary  conditions and/or      ===
c  assimilation fields for the Harvard PE model.                     ===
#ifndef surfpress
c  Streamfunction formulation                                        ===
#else
c  Streamfunction and Surface pressure formulation                   ===
#endif
c                                                                    ===
c  Harvard University Oceanography Group                             ===
c  Harvard Ocean Prediction System (HOPS)                            ===
c                                                                    ===
c  Hernan G. Arango                                                  ===
c  Carlos J. Lozano                                                  ===
c  Patrick J. Haley                                                  ===
c  Lyon L. Lanerolle                                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <curflds.h>
#include <grddat.h>
#include <hybrid.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <pi_netcdf.h>
#include <shapfil.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
       integer i,ip,iread,j,k,m,n,nrmbdy
       real c1,cm2m,day
#ifdef surfpress
       real c0,sumu,sumv
#endif
#ifdef sunfpe
       integer ieeer,my_handler,ieee_handler
#endif
       parameter(c1=1.0,cm2m=0.01)
#ifdef surfpress
       parameter(c0=0.0)
#endif
c
#ifdef sunfpe
       external my_handler
c
#endif
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef sunfpe
c-----------------------------------------------------------------------
c  Set trap for floating point exceptions.
c-----------------------------------------------------------------------
c
      ieeer=ieee_handler('set','common',my_handler)
      if(ieeer.ne.0) print *,' IEEE_HANDLER cannot set my_handler'
c
#endif
c-----------------------------------------------------------------------
c  Read in input paramenters.
c-----------------------------------------------------------------------
c
      call get_parm
c
c-----------------------------------------------------------------------
c  Set the depths of each tracer and velocity grid point which are
c  used to interpolate fields to hybrid coordinates.
c-----------------------------------------------------------------------
c
      call setdepths
c
c-----------------------------------------------------------------------
c  Create and define netCDF file. Write out parameters and time
c  independent variables.
c-----------------------------------------------------------------------
c
      call defcdf
c
c-----------------------------------------------------------------------
c  Read in input fields: streamfunction, QG bathymetry, temperature,
c  salinity, QG vertical velocity, and error fields when available.
c-----------------------------------------------------------------------
c
  10  continue
      if(job.eq.3) then
        call get_unif (day,iread)
       else if(ifile.eq.0) then
        call get_cdfdat(day,iread)
cjad
        if(itrc.eq.1) call get_trc(day)
       else
        call get_data(day,iread)
      endif
      if(day.gt.tstop) goto 120
c
      if (tidfld.gt.0) call get_tide (day)
c
c-----------------------------------------------------------------------
c  Non-dimensionalize any dimensional errors.
c-----------------------------------------------------------------------
c
      call scale_err
c
c-----------------------------------------------------------------------
c  Compute streamfunction from T,S
c-----------------------------------------------------------------------
c
      if ((its2psi.eq.1).and.(.not.ldrctvel)) call ts2psi
c
c-----------------------------------------------------------------------
c  If requested, Shapiro filter input fields.
c-----------------------------------------------------------------------
c
      if (mod(ifilter,2).eq.1) then
        do 30 k=1,kfld
        do 30 n=1,nrep
          call filter (psi(1,k),im,im,jm,nord)
          do 20 m=1,nt
            call filter (t(1,k,m),im,im,jm,nord)
  20      continue
  30    continue
      endif
c
c-----------------------------------------------------------------------
c  Set reference surface for streamfunction.
c-----------------------------------------------------------------------
c
      if ((job.ne.3).and.((iflag(5)/4).gt.0).and.(.not.ldrctvel))
     &   call set_psi
c
c-----------------------------------------------------------------------
c  Calculate vertically integrated streamfunction (transport).
c-----------------------------------------------------------------------
c
      if (job.lt.2) call psibar
c
c-----------------------------------------------------------------------
c  Calculate horizontal velocity (internal and external) field and
c  interpolate to hybrid coordinates.
c-----------------------------------------------------------------------
c
      call velocity
c
#ifdef surfpress
c-----------------------------------------------------------------------
c  Calculate horizontal velocity (external) field and surface pressure
c-----------------------------------------------------------------------
c
      if (ptype.gt.0) then
         call baro_velocity
         if ((ptype.eq.2).and.(job.ne.1)) then
            call reset_depths
         endif
      endif
c
#endif
#ifdef meantracer
c-----------------------------------------------------------------------
c  Compute mean tracer fields.
c-----------------------------------------------------------------------
c
      call set_meantrc
c
#endif
c-----------------------------------------------------------------------
c  Interpolate tracers to terrain-following coordinates.
c-----------------------------------------------------------------------
c
      do 40 n=1,nt
        call interp(t(1,1,n),depthmt,zfld,kfld,intopt)
        call interp(tmean(1,1,n),depthmt,zfld,kfld,intopt)
  40  continue
c
c-----------------------------------------------------------------------
c  If no data was provided for additional tracers, set them to unity.
c-----------------------------------------------------------------------
c
      if ((itrc.eq.0).and.(nt.gt.2)) then
        do 50 m=3,nt
        do 50 k=1,km
        do 50 j=1,jm
        do 50 i=1,im
          ip=i+(j-1)*im
          t(ip,k,m)=c1
  50    continue
      endif
c
#ifdef surfpress
c-----------------------------------------------------------------------
c   If free surface interpolate to updated vertical grid
c   (For assimilation fields, can NOT, in general, assume that enough
c    global information is present for reliable free surface.)
c-----------------------------------------------------------------------
c
      if ((ptype.eq.2).and.(job.ne.1)) then
         do 70 k=1,kfld
            do 60 ip=1,im*jm
               ui(ip,k)=uflat(ip,k)
               vi(ip,k)=vflat(ip,k)
  60        continue
  70     continue
c
         call interp(ui,depthmv,zfld,kfld,intopt)
         call interp(vi,depthmv,zfld,kfld,intopt)
c
c  Compute internal velocities from PE velocity.
c
         do 100 j=1,jm
            do 90 i=1,im
               sumu=c0
               sumv=c0
               ip=i+(j-1)*im
               do 80 k=1,km
                  sumu=sumu+ui(ip,k)*dzvf(ip,k)
                  sumv=sumv+vi(ip,k)*dzvf(ip,k)
  80           continue
               sumu = sumu/hvzf(ip)
               sumv = sumv/hvzf(ip)
               do 85 k = 1, km
                  ui(ip,k)=ui(ip,k)-sumu
                  vi(ip,k)=vi(ip,k)-sumv
  85           continue
  90        continue
 100     continue
         if ((job.ne.3).or.(in_ageo.ge.1)) then
            call putdiag ('TotalVelocity')
         endif
      endif
c
#endif
c-----------------------------------------------------------------------
c  Write out initial conditions or assimilation fields.
c-----------------------------------------------------------------------
c
      if(initial.eq.0) then
        call put_init
        if(job.ne.1) initial=1
      endif
c
c-----------------------------------------------------------------------
c  Write out boundary information.
c-----------------------------------------------------------------------
c
      if (job.ne.1) then
        do 110 nrmbdy = 1, 3
           call put_bry (nrmbdy)
 110    continue
      endif
      ncall=ncall+1
c
c-----------------------------------------------------------------------
c  Read and process fields for next time, if applicable.
c-----------------------------------------------------------------------
c
      if ((iread.eq.0).and.(day.lt.tstop)) goto 10
c
c-----------------------------------------------------------------------
c  Re-process time differential fields.
c-----------------------------------------------------------------------
c
 120  continue
c
      if (job.ne.1) then
        call timediff
      endif
c
      call exitus ('PE_INITIAL DONE')
c
      stop
      end
