       subroutine opencdf(inpname)
c
c=======================================================================
c                                                                    ===
c  This routine opens input NetCDF file for data access and reads    ===
c  in necessary information.                                         ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     INPNAME    input NetCDF filename (character)                   ===
c                                                                    ===
c  Required common blocks:                                           ===
c                                                                    ===
c     IOUNITS, MODDAT, NDIMEN, NETCDF, PI_NETCDF, ZDAT               ===
c                                                                    ===
c  Calls:                                                            ===
c                                                                    ===
c     NCAGTC, NCAINQ, NCDID, NCDINQ, NCOPN, NCPOPT, NCVGT, NCVGT1,   ===
c     NCVID  (NetCDF library)                                        ===
c     EXITUS                                                         ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <netcdf.inc>
#include <pi_netcdf.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer dimid,dimsiz,imdat,jmdat,k,n,lendim,lenstr,lenvar,sbgn,
     &        send,slen
      integer count(2),crddat,start(2)
      integer lnblk
      logical no_depths
      real c0,c1,dlxdt,dxdat,dlydt,dydat,eps,m2cm,p5,rladt,rlndt,thetdt,
     &     tol
      character*128 tst_str
      character*(*) inpname
      parameter (c0=0.0,c1=1.0,m2cm=100.0,p5=0.5,
     *           eps=1.19209 28955 07812 5 E-07, tol=eps*(c1+eps))
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Open input NetCDF file.
c
      call ncpopt(ncverbos)
      lenstr=lnblk(inpname,len(inpname))
      ncinpid=ncopn(inpname(1:lenstr),ncnowrit,rcode)
      if(rcode.eq.0) then
        ncinpfl=1
       else
        write(stdout,900) inpname(1:lenstr)
        call exitus('OPENCDF')
      endif
c
c  Inquire and get input "type" global attribute.
c
      call ncainq(ncinpid,ncglobal,'type',attype,ltype,rcode)
      if(rcode.eq.0) then
        call ncagtc(ncinpid,ncglobal,'type',type,ltype,rcode)
        if(rcode.ne.0) then
          write(stdout,901) 'type (global)',inpname(1:lenstr)
          call exitus('OPENCDF')
        endif
      else
        write(stdout,902) 'type (global)',inpname(1:lenstr)
        call exitus('OPENCDF')
      endif
c
c-----------------------------------------------------------------------
c  Inquire about the contents of input NetCDF file:  Inquire about the
c  dimensions and variables.
c-----------------------------------------------------------------------
c
      call ncinq(ncinpid,ndims,nvars,ngatts,recdim,rcode)
      if(rcode.eq.0) then
c
c  Inquire about dimensions.
c
        do 10 n=1,ndims
          dimid=n
          call ncdinq(ncinpid,dimid,dimnam,dimsiz,rcode)
          if(rcode.ne.0) then
            write(stdout,903) n,inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
          lendim=lnblk(dimnam,len(dimnam))
          if(dimnam(1:lendim).eq.'lon') then
            imdat=dimsiz
          elseif(dimnam(1:lendim).eq.'tlon') then
            imdat=dimsiz
          elseif(dimnam(1:lendim).eq.'vlon') then
            imdat=dimsiz
          elseif(dimnam(1:lendim).eq.'lat') then
            jmdat=dimsiz
          elseif(dimnam(1:lendim).eq.'tlat') then
            jmdat=dimsiz
          elseif(dimnam(1:lendim).eq.'vlat') then
            jmdat=dimsiz
          elseif(dimnam(1:lendim).eq.'level') then
            kfld=dimsiz
          elseif(dimnam(1:lendim).eq.'level1') then
            kfld=dimsiz
          endif
  10    continue
c
        if (im.ne.imdat) write (stdout,910) 'im',im,'im',imdat
        if (jm.ne.jmdat) write (stdout,910) 'jm',jm,'jm',jmdat
        if ((im.ne.imdat).or.(jm.ne.jmdat)) call exitus('OPENCDF')
c
c  Inquire about variables.
c
        do 20 n=1,nvars
          varid=n
          call ncvinq(ncinpid,varid,varnam(n),vartyp,nvdims(n),
     *                vdims(1,n),nvatts,rcode)
          if(rcode.ne.0) then
            write(stdout,904) n,inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
  20    continue
      else
        write(stdout,905) inpname(1:lenstr)
        call exitus('OPENCDF')
      endif
c
c-----------------------------------------------------------------------
c  Get information about various parameters: model domain and scales.
c  Scale to CGS when appropriate.
c-----------------------------------------------------------------------
c
      v0=c1
      dhor=c1
      ht=c1
      do 30 n=1,nvars
        varid=n
        lenvar=lnblk(varnam(n),len(varnam(n)))
        if(varnam(n)(1:lenvar).eq.'coord') then
          call ncvgt1(ncinpid,varid,1,crddat,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'rlngd') then
          call ncvgt1(ncinpid,varid,1,rlndt,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'rlatd') then
          call ncvgt1(ncinpid,varid,1,rladt,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'thetad') then
          call ncvgt1(ncinpid,varid,1,thetdt,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'xbasin') then
          call ncvgt1(ncinpid,varid,1,xbasin,rcode)
          xbasin=xbasin*m2cm
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'ybasin') then
          call ncvgt1(ncinpid,varid,1,ybasin,rcode)
          ybasin=ybasin*m2cm
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'dx') then
          call ncvgt1(ncinpid,varid,1,dxdat,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'delx') then
          call ncvgt1(ncinpid,varid,1,dlxdt,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'dy') then
          call ncvgt1(ncinpid,varid,1,dydat,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'dely') then
          call ncvgt1(ncinpid,varid,1,dlydt,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'dhor') then
          call ncvgt1(ncinpid,varid,1,dhor,rcode)
          dhor=dhor*m2cm
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'ht') then
          ht=ht*m2cm
          call ncvgt1(ncinpid,varid,1,ht,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'v0') then
          call ncvgt1(ncinpid,varid,1,v0,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
          v0=v0*m2cm
        elseif(varnam(n)(1:lenvar).eq.'r0') then
          call ncvgt1(ncinpid,varid,1,r0,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'t0') then
          call ncvgt1(ncinpid,varid,1,t0,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'time0') then
          call ncvgt1(ncinpid,varid,1,time0,rcode)
          if(rcode.ne.0) then
            write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        endif
  30  continue
      if (xbasin.eq.c0) xbasin=float(im-1)*dx
      if (ybasin.eq.c0) ybasin=float(jm-1)*dy
      if (crddat.eq.0) then
        dxdat = dxdat*m2cm
        dydat = dydat*m2cm
        dlxdt = dlxdt*m2cm
        dlydt = dlydt*m2cm
      endif
c
      if(coord.ne.crddat) write(stdout,911) 'coord',coord,'coord',crddat
      if(abs(dx-dxdat).gt.tol*abs(dx))
     *  write(stdout,912) 'dx',dx,'dx',dxdat
      if(abs(delx-dlxdt).gt.tol*abs(delx))
     *  write(stdout,912) 'delx',delx,'delx',dlxdt
      if(abs(dy-dydat).gt.tol*abs(dy))
     *  write(stdout,912) 'dy',dy,'dy',dydat
      if(abs(dely-dlydt).gt.tol*abs(dely))
     *  write(stdout,912) 'dely',dely,'dely',dlydt
      if(abs(rlat0-rladt).gt.tol*abs(rlat0))
     *  write(stdout,912) 'rlatd',rlat0,'rlatd',rladt
      if(abs(rlng0-rlndt).gt.tol*abs(rlng0))
     *  write(stdout,912) 'rlngd',rlng0,'rlngd',rlndt
      if(abs(thetad-thetdt).gt.tol*abs(thetad))
     *  write(stdout,912) 'thetad',thetad,'thetad',thetdt
c
c-----------------------------------------------------------------------
c  Read in depths and thicknesses (meters) at the center of the flat
c  vertical boxes.  Scale to CGS.
c-----------------------------------------------------------------------
c
      no_depths=.true.
c
      do 70 n=1,nvars
        varid=n
        lenvar=lnblk(varnam(n),len(varnam(n)))
        if(varnam(n)(1:lenvar).eq.'hz') then
          call ncdinq(ncinpid,vdims(1,n),dimnam,dimsiz,rcode)
          if(rcode.eq.0) then
            start(1)=1
            count(1)=dimsiz
            call ncvgt(ncinpid,varid,start,count,hzfld,rcode)
            hzfld(1)=hzfld(1)*m2cm
            if(no_depths) zfld(1)=p5*hzfld(1)
            do 40 k=2,dimsiz
              hzfld(k)=hzfld(k)*m2cm
              if(no_depths) zfld(k)=zfld(k-1)+p5*(hzfld(k)+hzfld(k-1))
  40        continue
            if(no_depths) zbot=zfld(dimsiz)+p5*hzfld(dimsiz)
            no_depths=.false.
            if(rcode.ne.0) then
              write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
              call exitus('OPENCDF')
            endif
          else
            write(stdout,907) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'zqg') then
          call ncdinq(ncinpid,vdims(1,n),dimnam,dimsiz,rcode)
          if(rcode.eq.0) then
            start(1)=1
            count(1)=dimsiz
            call ncvgt(ncinpid,varid,start,count,zfld,rcode)
            do 50 k=1,dimsiz
              zfld(k)=abs(zfld(k))*m2cm
  50        continue
            zbot=zfld(dimsiz)
            no_depths=.false.
            if(rcode.ne.0) then
              write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
              call exitus('OPENCDF')
            endif
          else
            write(stdout,907) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        elseif(varnam(n)(1:lenvar).eq.'zout') then
          call ncdinq(ncinpid,vdims(2,n),dimnam,dimsiz,rcode)
          if(rcode.eq.0) then
            start(1)=zindx
            count(1)=1
            start(2)=1
            count(2)=dimsiz
            call ncvgt(ncinpid,varid,start,count,zfld,rcode)
            do 60 k=1,dimsiz
              zfld(k)=abs(zfld(k))*m2cm
  60        continue
            zbot=zfld(dimsiz)
            no_depths=.false.
            if(rcode.ne.0) then
              write(stdout,906) varnam(n)(1:lenvar),inpname(1:lenstr)
              call exitus('OPENCDF')
            endif
          else
            write(stdout,907) varnam(n)(1:lenvar),inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        endif
  70  continue
c
c-----------------------------------------------------------------------
c  Inquire size of unlimited record dimension TIME and read its values.
c-----------------------------------------------------------------------
c
      if(recdim.ne.-1) then
        call ncdinq(ncinpid,recdim,dimnam,ntime,rcode)
        if(rcode.ne.0) then
          write(stdout,907) 'time',inpname(1:lenstr)
          call exitus('OPENCDF')
        endif
        varid=ncvid(ncinpid,'time',rcode)
        if(rcode.eq.0) then
          start(1)=1
          count(1)=ntime
          call ncvgt(ncinpid,varid,start,count,time,rcode)
          if(rcode.ne.0) then
            write(stdout,906) 'time',inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
        else
          write(stdout,908) 'time',inpname(1:lenstr)
          call exitus('OPENCDF')
        endif
      else
        varid=ncvid(ncinpid,'time',rcode)
        if(rcode.eq.0) then
          call ncvgt1(ncinpid,varid,1,time(1),rcode)
          if(rcode.ne.0) then
            write(stdout,906) 'time',inpname(1:lenstr)
            call exitus('OPENCDF')
          endif
          ntime=1
        else
          write(stdout,908) 'time',inpname(1:lenstr)
          call exitus('OPENCDF')
        endif
      endif
c
c-----------------------------------------------------------------------
c  Determine if error fields are present.
c-----------------------------------------------------------------------
c
      if (job.eq.1) then
c
         call ncpopt (0)
c
         do 80 n=1,nt
            call length (tname(1,n),slen,sbgn,send)
            tst_str = tname(1,n)(sbgn:send)//'err'
            call length (tst_str,slen,sbgn,send)
            varid = ncvid (ncinpid,tst_str(sbgn:send),rcode)
            if (rcode.eq.0) lwrtoerr=.true.
  80     continue
c
         varid = ncvid (ncinpid,'dynhterr',rcode)
         if (rcode.eq.0) lwrtoerr=.true.
c
         varid = ncvid (ncinpid,'strmerr',rcode)
         if (rcode.eq.0) lwrtoerr=.true.
c
         varid = ncvid (ncinpid,'vtoterr',rcode)
         if (rcode.eq.0) lwrtoerr=.true.
c
         varid = ncvid (ncinpid,'error',rcode)
         if (rcode.eq.0) lwrtoerr=.true.
c
         call ncpopt (ncverbos)
c
      endif
c
 900  format(/' OPENCDF - unable to open NetCDF file: ',a)
 901  format(/' OPENCDF - error while reading attribute: ',a,2x,
     *        ' in input NetCDF file: ',a)
 902  format(/' OPENCDF - cannot find attribute: ',a,2x,
     *        ' in input NetCDF file: ',a)
 903  format(/' OPENCDF - error while inquiring dimension ID: ',i3,2x,
     *        ' in input NetCDF file: ',a)
 904  format(/' OPENCDF - error while inquiring variable ID: ',i3,2x,
     *        ' in input NetCDF file: ',a)
 905  format(/' OPENCDF - unable to inquire about contents of',
     *         ' input NetCDF file: ',a)
 906  format(/' OPENCDF - error while reading variable: ',a,2x,
     *        ' in input NetCDF file: ',a)
 907  format(/' OPENCDF - error inquiring dimension for variable: ',a,
     *       2x,' in input NetCDF file: ',a)
 908  format(/' OPENCDF - cannot find for variable: ',a,2x,
     *        ' in input NetCDF file: ',a)
 910  format (/' OPENCDF - Incompatible dimensions:'/11x,'GRIDS ',a,
     *       ' = ',i10/11x,'Data ',a,' = ',i10)
 911  format (/' OPENCDF - Unequal domain parameter, taking GRIDS value'
     *        /11x,'GRIDS ',a,' = ',i10/11x,'Data ',a,' = ',i10)
 912  format (/' OPENCDF - Unequal domain parameter, taking GRIDS value'
     *        /11x,'GRIDS ',a,' = ',1pg15.8/11x,'Data ',a,' = ',1pg15.8)
      return
      end
