      subroutine read1cdf(ncinpid,tindx,vindx,varid,varnam,nvdims,vdims,
     *                    field,np)
c
c=======================================================================
c                                                                    ===
c  This routine reads in requested field from input NetCDF file.     ===
c  The variable is assumed to have 1 spatial dimension.              ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     NCINPID    NetCDF ID for input file (integer).                 ===
c     TINDX      Time index to read (integer).                       ===
c     VINDX      Vector index to read.   (integer)                   ===
c     VARID      NetCDF ID of variable to read (integer).            ===
c     VARNAM     variable name (character).                          ===
c     NVDIMS     number of dimensions for variable (integer).        ===
c     VDIMS      NetCDF dimension IDs for variable (integer array).  ===
c     NP         Number of spatial points allocated for variable     ===
c                in calling program (integer).                       ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     FIELD      requested 1D variable (real array).                 ===
c                                                                    ===
c  Required Common blocks:                                           ===
c                                                                    ===
c     /IOUNITS/                                                      ===
c                                                                    ===
c  Calls:                                                            ===
c                                                                    ===
c     NCDINQ, NCVGT  (NetCDF library)                                ===
c     EXITUS, LNBLK                                                  ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer dimid,dimsiz,lendim,lenvar,ncinpid,n,ndt,np,
     *        npts,tindx,nvdims,rcode,varid,vindx
      integer count(5),start(5),vdims(nvdims)
      integer lnblk
      real field(np)
      character*2   nmml
      character*128 dimnam,nmdt
      character*(*) varnam
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      lenvar=lnblk(varnam,len(varnam))
      do 10 n=1,nvdims
        dimid=vdims(n)
        call ncdinq(ncinpid,dimid,dimnam,dimsiz,rcode)
        if(rcode.ne.0) then
          write(stdout,900) dimid,varnam(1:lenvar)
          call exitus('READ1CDF')
        endif
        lendim=lnblk(dimnam,len(dimnam))
        if((dimnam(1:lendim).eq.'lon').or.
     *     (dimnam(1:lendim).eq.'tlon').or.
     *     (dimnam(1:lendim).eq.'vlon')) then
          start(n) = 1
          count(n) = dimsiz
          npts = dimsiz
          nmdt = dimnam(1:lendim)
          ndt  = lendim
          nmml = 'np'
        elseif((dimnam(1:lendim).eq.'lat').or.
     *         (dimnam(1:lendim).eq.'tlat').or.
     *         (dimnam(1:lendim).eq.'vlat')) then
          start(n)=1
          count(n)=dimsiz
          npts=dimsiz
          nmdt = dimnam(1:lendim)
          ndt  = lendim
          nmml = 'np'
        elseif(dimnam(1:lendim).eq.'level') then
          start(n)=1
          count(n)=dimsiz
          npts=dimsiz
          nmdt = dimnam(1:lendim)
          ndt  = lendim
          nmml = 'nz'
        elseif(dimnam(1:lendim).eq.'time') then
          start(n)=tindx
          count(n)=1
        elseif(dimnam(1:lendim).eq.'vector') then
          start(n)=vindx
          count(n)=1
        endif
  10  continue
c
c  Check if the array size allocated is sufficient.
c
      if(npts.gt.np) then
        write(stdout,901) nmdt(1:ndt),npts,nmml,np,nmml
        call exitus('READ1CDF')
      endif
c
c  Read in requested 1D field.
c
      call ncvgt(ncinpid,varid,start,count,field,rcode)
      if(rcode.ne.0) then
        write(stdout,902) varnam(1:lenvar)
        call exitus('READ1CDF')
      endif
c
 900  format(/' READ1CDF - error while inquiring dimension: ',a,2x,
     *        ' for variable: ',a,2x,' in input NetCDF file.' )
 901  format(/' READ1CDF - required array size, ',a,' = ',i6,2x,
     *        ' is bigger than that allocated, ',a,' = ',i6,/,12x,
     *        ' Change parameter ',a,' and recompile.')
 902  format(/' READ1CDF - error while reading variable: ',a)
      return
      end
