      subroutine scale_err
c
c=======================================================================
c                                                                    ===
c     This routine non-dimensionalizes the specified errors based    ===
c     upon the RMS deviation from a mean.  Any rescaled errors are   ===
c     also squared to convert them to a variance based measure.      ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c     IM       number of points in the x-direction.                  ===
c     JM       number of points in the y-direction.                  ===
c     NT       number of tracer variables.                           ===
c                                                                    ===
c  /OBSERR/                                                          ===
c                                                                    ===
c     PSIOERR  observation error field for streamfunction/dynamic    ===
c              height.                                               ===
c     PSIOSCL  error scale for streamfunction/dynamic height.        ===
c     TOERR    observation error field for tracer variables.         ===
c     TOSCL    error scale for tracer variables                      ===
c                                                                    ===
c  /SWITCHES/                                                        ===
c                                                                    ===
c     IOERR    flags indicating the availability of observation      ===
c              error fields for each variable: [0] no,  [1] yes.     ===
c     IOSCL    flags indicating the necessity of rescaling error     ===
c              fields for each variable: [0] no,  [1] yes.           ===
c                                                                    ===
c  /ZDAT/                                                            ===
c                                                                    ===
c     KFLD     number of levels in input data (integer).             ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <ndimen.h>
#include <obserr.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ij,imjm,k,n
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Set number of points.
c-----------------------------------------------------------------------
c
      imjm=im*jm
c
c-----------------------------------------------------------------------
c  Rescale dynamic height or streamfunction errors, if needed.
c-----------------------------------------------------------------------
c
      if ((ioerr(0).ne.0).and.(ioscl(0).ne.0)) then
        do 20 k = 1, kfld
          do 10 ij = 1, imjm
              psioerr(ij,k)=psioerr(ij,k)/psioscl(k)
              psioerr(ij,k)=psioerr(ij,k)*psioerr(ij,k)
  10      continue
  20    continue
        ioscl(0)=0
      end if
c
c-----------------------------------------------------------------------
c  Rescale tracer errors, if needed.
c-----------------------------------------------------------------------
c
      do 50 n = 1, nt
        if ((ioerr(n+4).ne.0).and.(ioscl(n+4).ne.0)) then
          do 40 k = 1, kfld
            do 30 ij = 1, imjm
              toerr(ij,k,n)=toerr(ij,k,n)/toscl(k,n)
              toerr(ij,k,n)=toerr(ij,k,n)*toerr(ij,k,n)
  30        continue
  40      continue
          ioscl(n+4)=0
        end if
  50  continue
c
c-----------------------------------------------------------------------
c  Rescale velocity errors, if needed.
c-----------------------------------------------------------------------
c
      if ((ioerr(1).ne.0).and.(ioscl(1).ne.0)) then
        do 70 k = 1, kfld
          do 60 ij = 1, imjm
              uoerr(ij,k)=uoerr(ij,k)/uoscl(k)
              uoerr(ij,k)=uoerr(ij,k)*uoerr(ij,k)
  60      continue
  70    continue
        ioscl(1)=0
      end if
c
      if ((ioerr(2).ne.0).and.(ioscl(2).ne.0)) then
        do 90 k = 1, kfld
          do 80 ij = 1, imjm
              voerr(ij,k)=voerr(ij,k)/voscl(k)
              voerr(ij,k)=voerr(ij,k)*voerr(ij,k)
  80      continue
  90    continue
        ioscl(2)=0
      end if
c
      return
      end
