      subroutine set_oerr(dcur)
c
c=======================================================================
c                                                                    ===
c  This routine processes observation error fields to be used in     ===
c  the  OI  assimilation. Observations  errors are assumed to be     ===
c  normalized by their variance, so their values range from zero     ===
c  to one.                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <fdiag.h>
#include <hybrid.h>
#include <iounits.h>
#include <ndimen.h>
#include <obserr.h>
#include <pefldid.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer k,m,trcshft
      real    c0,c1,dcur,eval
      parameter (c1=1.0,c0=0.0)
c
      data trcshft /3/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      write(stdout,10) dcur
  10  format(/,' Writing observation error fields for day = ',f12.4,/)
c
c-----------------------------------------------------------------------
c  Process observation errors.  Set error fields to EVAL when
c  the when such fields are nonexisting in the data file.  If
c  the velocity errors (internal and external components) are
c  not present derive them from the streamfunction field.
c-----------------------------------------------------------------------
c
      eval=c1
c
c  Observation errors for internal velocity.
c
c    Direct errors
c
      if (ioerr(1).eq.1) then
         call interp (uoerr,depthmv,zfld,kfld,intopt)
         call errlim (uoerr,km)
      end if
c
      if (ioerr(2).eq.1) then
         call interp (voerr,depthmv,zfld,kfld,intopt)
         call errlim (voerr,km)
      end if
c
c    Constructed errors
c
      if ((ioerr(1).eq.0).and.(ioerr(2).eq.1)) then
         call cperr (voerr,km,uoerr)
      elseif ((ioerr(1).eq.0).and.(ioerr(0).eq.1)) then
         call cperr (psioerr,kfld,uoerr)
         call interp (uoerr,depthmv,zfld,kfld,intopt)
         call errlim (uoerr,km)
      elseif ((ioerr(1).eq.0).and.(ioerr(0).eq.0)) then
         call errdef (uoerr,km,eval)
      endif
c
      if (ioerr(2).eq.0) then
         call cperr (uoerr,km,voerr)
      endif
c
c  Observation errors for transport streamfunction (external velocity)
c
      if ((ioerr(1).eq.1).or.(ioerr(2).eq.1)) then
         call v2perr (uoerr,voerr,psioerr)
         ioerr(0) = 1
       else
         call interp (psioerr,depthmt,zfld,kfld,intopt)
      endif
      if((ioerr(4).eq.0).and.(ioerr(0).eq.1)) then
         call p2pber (psioerr,pbaroerr)
         call errlim (pbaroerr,1)
      else
         call errdef (pbaroerr,1,eval)
      endif
c
#ifdef surfpress
c  Observation errors for external velocity (surface pressure formulation only).
c
      if (ptype.gt.0) then
         call v2vber (uoerr,ubaroerr)
         call v2vber (voerr,vbaroerr)
      endif
c
#endif
c  Tracers.
c
      do 20 m=1,nt
        if(ioerr(m+4).eq.1) then
          call errlim (toerr(1,1,m),kfld)
          call interp(toerr(1,1,m),depthmt,zfld,kfld,intopt)
          call errlim (toerr(1,1,m),km)
        else
          call errdef (toerr(1,1,m),km,eval)
        endif
  20  continue
c
c----------------------------------------------------------------------
c  Get minimum and maximum values to be used in the assimilation.
c----------------------------------------------------------------------
c
c  Transport streamfunction/Surface pressure diagnostics.
c
#ifdef surfpress
      if (ptype.eq.0) then
#endif
         call fdiagn(pbaroerr,im,im,jm,pepoer,0,dcur)
#ifdef surfpress
       else
         call fdiagn(pbaroerr,im,im,jm,pesfor,0,dcur)
      endif
#endif
      do 30 k=1,km
        oerrmin(1,k)=min(fmin,c0)
        oerrmax(1,k)=max(fmax,c1)
  30  continue
c
c  Internal velocity field diagnostics.
c
      do 40 k=1,km
        call fdiagn(uoerr(1,k),im,im,jm,peuoer,k,dcur)
        oerrmin(2,k)=min(fmin,c0)
        oerrmax(2,k)=max(fmax,c1)
  40  continue
      do 50 k=1,km
        call fdiagn(voerr(1,k),im,im,jm,pevoer,k,dcur)
        oerrmin(3,k)=min(fmin,c0)
        oerrmax(3,k)=max(fmax,c1)
  50  continue
c
#ifdef surfpress
c  External velocity field diagnostics.
c
      if (ptype.gt.0) then
         call fdiagn(ubaroerr,im,im,jm,peubor,0,dcur)
         do 60 k=1,km
           oerrmin(4,k)=min(fmin,c0)
           oerrmax(4,k)=max(fmax,c1)
  60     continue
         call fdiagn(vbaroerr,im,im,jm,pevbor,0,dcur)
         do 70 k=1,km
           oerrmin(5,k)=min(fmin,c0)
           oerrmax(5,k)=max(fmax,c1)
  70     continue
         trcshft = 5
       else
         trcshft = 3
      endif
c
#endif
c  Tracer diagnostics.
c
      do 90 m=1,nt
        do 80 k=1,km
          call fdiagn(toerr(1,k,m),im,im,jm,toerid(m),k,dcur)
          oerrmin(m+trcshft,k)=min(fmin,c0)
          oerrmax(m+trcshft,k)=max(fmax,c1)
  80    continue
  90  continue
      return
      end
