      subroutine v2perr (uerr,verr,psierr)
c
c=======================================================================
c                                                                    ===
c  This constructs a streamfunction error from velocity errors.      ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     UERR     Zonal velocity error field.             (real array)  ===
c     VERR     Meridional velocity error field.        (real array)  ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c     IM   number of points in the x-direction.  (integer)           ===
c     JM   number of points in the y-direction.  (integer)           ===
c     KM   number of points in the z-direction.  (integer)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     PSIERR   Streamfunction error field.             (real array)  ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <ndimen.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,im1,ip,ipm1,ipmim,ipmim1,j,jm1,k
      real    p125
      real psierr(np,nz),uerr(np,nz),verr(np,nz)
c
      parameter (p125=0.125)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 30 k = 1, km
         do 20 j = 1, jm
            jm1 = max(j-1,1)
            do 10 i = 1, im
               im1 = max(i-1,1)
               ip     = i + (j-1)*im
               ipm1   = im1 + (j-1)*im
               ipmim  = i + (jm1-1)*im
               ipmim1 = im1 + (jm1-1)*im
               psierr(ip,k) = p125*(uerr(ip,k)+uerr(ipm1,k)+
     &                              uerr(ipmim,k)+uerr(ipmim1,k)+
     &                              verr(ip,k)+verr(ipm1,k)+
     &                              verr(ipmim,k)+verr(ipmim1,k))
  10        continue
  20     continue
  30  continue
c
      return
      end
