      subroutine v2vber (velerr,vberr)
c
c=======================================================================
c                                                                    ===
c  This routine constructs a barotropic velocity error field by      ===
c  vertically averaging the velocity error field.                    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     VELERR   Velocity error field.             (real array)        ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /HYBRID/                                                          ===
c                                                                    ===
c     DZV   Thicknesses over V-grid.       (real array; cm)          ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c     IM   number of points in the x-direction.  (integer)           ===
c     JM   number of points in the y-direction.  (integer)           ===
c     KM   number of points in the z-direction.  (integer)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     VBERR   Barotropic velocity error field.    (real array)       ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <hybrid.h>
#include <ndimen.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ip,k
      real    dztot
      real vberr(np),velerr(np,nz)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 20 ip = 1, im*jm
         vberr(ip) = velerr(ip,1)*dzv(ip,1)
         dztot     = dzv(ip,1)
         do 10 k = 2, km
            vberr(ip) = vberr(ip) + velerr(ip,k)*dzv(ip,k)
            dztot     = dztot + dzv(ip,k)
  10     continue
         vberr(ip) = vberr(ip)/dztot
  20  continue
c
      return
      end
