      program fakenest
c
c=======================================================================
c                                                                    ===
c  This program takes the output of a PE model run and overwrites a  ===
c  PE_initial file.                                                  ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
#ifndef sunfpe
c     EXTTYPE,  GET_DIM,  GET_FLD,  GET_SCLR,  UDIEJOE,  WRT_FLD,    ===
c     WRT_SCLR                                                       ===
# else
c     EXTTYPE,  GET_DIM,  GET_FLD,  GET_SCLR,  MY_HANDLER,  UDIEJOE, ===
c     WRT_FLD,  WRT_SCLR                                             ===
#endif
c                                                                    ===
c     netCDF:  NCCLOS,  NCOPN                                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <fnparam.h>
#include <fncoast.h>
#include <netcdf.inc>
#include <netstat.h>
#include <domsdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer trcnd,trcst
#if !defined bioDuse & !defined cod_model
      parameter (trcnd=2)
#elif !defined cod_model
      parameter (trcnd=9)
#else
      parameter (trcnd=10)
#endif
#if !defined nophys & !defined cod_only
      parameter (trcst=1)
#elif !defined cod_only
      parameter (trcst=3)
#else
      parameter (trcst=10)
#endif
c
      real    cm2deg,pi,re,sec2day
      integer baro,genscl
      parameter (genscl=0, baro=-1, sec2day=1.0/86400.0,
     &           pi=3.14159 26535 89793 23846, re=637131500.0)
      parameter (cm2deg=180.0/(re*pi))
#ifdef nestvclin
      integer zax
      parameter (zax=3)
#endif
c
      real    fld(maxpt),fld2(maxpt),dt,t0
#ifdef nestvclin
     &        ,dzin(maxpt),dzout(maxpt)
#endif
      integer err,ijmx,imt1,imt2,jmt1,jmt2,lev1,lev2,n,nnd,nst,tim0,
     &        tim1,tim2,trcind,velind
#ifdef sunfpe
     &        ,ieeer,my_handler,ieee_handler
#endif
      integer mask(max2),msk2(max2),vmsk(max2),wk(max2,3)
      logical      dobndy,dum,ismsk1,ismsk2,ispe,issfn,pi_issfn
      character*1  answ
      character*80 outfile,infile,extname,bxname
      character*47 trcnam(10)
c
#ifdef sunfpe
      external my_handler
c
#endif
      data dum,ismsk1 /.false.,.false./
      data dt /0.0/
c
cjad - note that the order of the names must match those in the pemodel
c      and peinitial
c
      data trcnam(1) /'temp                                           '/
      data trcnam(2) /'salt                                           '/
      data trcnam(3) /'NO3                                            '/
      data trcnam(4) /'CELLNO3                                        '/
      data trcnam(5) /'zoo                                            '/
      data trcnam(6) /'NH4                                            '/
      data trcnam(7) /'detritus                                       '/
      data trcnam(8) /'CHL                                            '/
      data trcnam(9) /'CELLNH4                                        '/
      data trcnam(10)/'cod                                            '/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef sunfpe
c-----------------------------------------------------------------------
c  Enable floating point error flags.
c-----------------------------------------------------------------------
c
      ieeer = ieee_handler ('set','common',my_handler)
      if (ieeer .ne. 0) write (6,10)
c
#endif
c-----------------------------------------------------------------------
c  Get netCDF file names.
c-----------------------------------------------------------------------
c
      write (6,20) 'PE output'
      read (5,30) infile
c
      write (6,20) 'PE_initial'
      read (5,30) outfile
c
c-----------------------------------------------------------------------
c  Open netCDF files.
c-----------------------------------------------------------------------
c
      call ncpopt (ncverbos)
c
      ncid1 = ncopn (infile,ncnowrit,err)
      if (err.eq.0) then
         ncflg1 = 1
        else
         write (6,40) infile
         call udiejoe ('FAKENEST')
      end if
c
      ncid2 = ncopn (outfile,ncwrite,err)
      if (err.eq.0) then
         ncflg2 = 1
        else
         write (6,40) outfile
         call udiejoe ('FAKENEST')
      end if
c
c-----------------------------------------------------------------------
c  Find the size of the variables and the length of the time series
c  in both files.
c-----------------------------------------------------------------------
c
      call get_dim (ncid1,'tlon',infile,imt1)
      call get_dim (ncid1,'tlat',infile,jmt1)
      call getnedim (ncid1,'outlev',infile,lev1,ispe)
      if (.not.ispe) then
         call get_dim (ncid1,'level',infile,lev1)
         call getnedim (ncid1,'time0',infile,tim1,dum)
      end if
      if (.not.dum) call get_dim (ncid1,'time',infile,tim1)
c
      call get_dim (ncid2,'tlon',outfile,imt2)
      call get_dim (ncid2,'tlat',outfile,jmt2)
      call get_dim (ncid2,'level',outfile,lev2)
      call get_dim (ncid2,'time0',outfile,tim0)
      call get_dim (ncid2,'time',outfile,tim2)
c
c-----------------------------------------------------------------------
c  Check dimension sizes.
c-----------------------------------------------------------------------
c
      if (lev1.ne.lev2) write (6,50) 'nlev',lev1,'nlev',lev2
c
      if ((imt1*jmt1*lev1).gt.maxpt) write (6,60) imt1*jmt1*lev1,maxpt
      if ((imt2*jmt2*lev2).gt.maxpt) write (6,60) imt2*jmt2*lev2,maxpt
      if ((imt1*jmt1).gt.max2) write (6,70) imt1*jmt1,max2
c
      if ((lev1.ne.lev2).or.((imt1*jmt1*lev1).gt.maxpt).or.
     &             ((imt2*jmt2*lev2).gt.maxpt).or.((imt1*jmt1).gt.max2))
     &   call udiejoe ('FAKENEST')
c
      ijmx = max ( imt2 , jmt2)
c
c-----------------------------------------------------------------------
c  Determine type of external mode.
c-----------------------------------------------------------------------
c
      call exttype (ncid1,infile,issfn,extname)
      call exttype (ncid2,outfile,pi_issfn,extname)
c
      if (issfn.neqv.pi_issfn) then
         write (6,80)
         call udiejoe ('FAKENEST')
      end if
c
      if (issfn) then
         bxname = 'pbry'
       else
         bxname = 'spbry'
      endif
c
c-----------------------------------------------------------------------
c  Inquire about the desired starting time index.
c-----------------------------------------------------------------------
c
      write (6,90) tim1
      read (5,*) nst
c
      write (6,100) nst,tim1
      read (5,*) nnd
c
      write (6,110)
      read (5,'(a1)') answ
      dobndy = (answ.eq.'y') .or. (answ.eq.'Y')
c
      if (.not.dobndy) nnd=nst
c
c-----------------------------------------------------------------------
c  Get initial time.
c-----------------------------------------------------------------------
c
      call get_time0 (ncid1,infile,ncid2,outfile,t0)
c
c-----------------------------------------------------------------------
c  Get horizontal grid parameters.
c-----------------------------------------------------------------------
c
      call get_isclr (ncid1,'coord',infile,1,crd1)
      call get_sclr  (ncid1,'rlngd',infile,1,lonc1)
      call get_sclr  (ncid1,'rlatd',infile,1,latc1)
      call get_sclr  (ncid1,'thetad',infile,1,thet1)
      if (ispe) then
         call get_sclr  (ncid1,'dxt',infile,1,dx1)
         if (crd1.ne.0) dx1 = dx1*cm2deg
         call get_sclr  (ncid1,'dyt',infile,1,dy1)
         if (crd1.ne.0) dy1 = dy1*cm2deg
       else
         call get_sclr  (ncid1,'gridx',infile,1,dx1)
         call get_sclr  (ncid1,'gridy',infile,1,dy1)
      end if
      call get_sclr  (ncid1,'delx',infile,1,dlx1)
      call get_sclr  (ncid1,'dely',infile,1,dly1)
c
      call get_isclr (ncid2,'coord',outfile,1,crd2)
      call get_sclr  (ncid2,'rlngd',outfile,1,lonc2)
      call get_sclr  (ncid2,'rlatd',outfile,1,latc2)
      call get_sclr  (ncid2,'thetad',outfile,1,thet2)
      call get_sclr  (ncid2,'gridx',outfile,1,dx2)
      call get_sclr  (ncid2,'gridy',outfile,1,dy2)
      call get_sclr  (ncid2,'delx',infile,1,dlx2)
      call get_sclr  (ncid2,'dely',infile,1,dly2)
c
c-----------------------------------------------------------------------
c  Get input land mask (if applicable).
c-----------------------------------------------------------------------
c
      if (ispe) then
         call get_mask (ncid1,'landt',infile,imt1,jmt1,mask,ismsk1)
         call get_mask (ncid1,'landv',infile,imt1,jmt1,vmsk,ismsk1)
      endif
c
      call get_mask (ncid2,'landt',outfile,imt2,jmt2,msk2,ismsk2)
      if (ismsk2) then
         call get_dim (ncid2,'ncseg',outfile,ncst)
         call get_dim (ncid2,'lcseg',outfile,mxlncs)
         call get_ivec (ncid2,'lencoast',outfile,ncst,lencst)
         call get_mask (ncid2,'icoast',outfile,mxlncs,ncst,icst,ismsk2)
         call get_mask (ncid2,'jcoast',outfile,mxlncs,ncst,jcst,ismsk2)
         call setcmsk (imt2,jmt2,msk2)
      endif
c
#ifdef nestvclin
c-----------------------------------------------------------------------
c  Get V-box thicknesses, to ensure baroclinicity.
c-----------------------------------------------------------------------
c
      call get_fld (ncid1,'vgrid3',infile,nst,imt1,jmt1,lev1,zax,fld)
      call get_thick (imt1,jmt1,lev1,fld,dzin)
      call get_fld (ncid2,'vgrid3',outfile,nst,imt2,jmt2,lev2,zax,fld)
      call get_thick (imt2,jmt2,lev2,fld,dzout)
c
#endif
c-----------------------------------------------------------------------
c  Take initial field from PE output and use it for initial and
c  starting boundary conditions.
c-----------------------------------------------------------------------
#if !defined cod_only & !defined nophys
c
c  Transfer time.
c
      do n = nst, nnd
         call get_sclr (ncid1,'time',infile,n,dt)
         dt = dt*sec2day
         if (n.eq.nst) call wrt_sclr (ncid2,'time0',outfile,1,t0+dt)
         if (dobndy) call wrt_sclr(ncid2,'time',outfile,(n+1-nst),t0+dt)
      end do
#endif
c
c  Transfer tracers.
c
      do n = nst, nnd
         do trcind = trcst, trcnd
            call get_fld (ncid1,trcnam(trcind),infile,n,imt1,jmt1,lev1,
     &                                                       genscl,fld)
            if (ismsk1)
     &         call smooth_under (imt1,jmt1,lev1,fld,mask,1,max2,wk)
            call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
            if (n.eq.nst)
     &         call wrt_fld (ncid2,trcnam(trcind),outfile,1,imt2,jmt2,
     &                                                 lev2,genscl,fld2)
            if (dobndy) then
               call get_bndy (3,imt2,jmt2,ijmx,lev2,fld2,fld)
               call wrt_bdy (ncid2,'tbry',outfile,(n+1-nst),imt2,jmt2,
     &                                             ijmx,lev2,trcind,fld)
            endif
         end do
      end do
#if !defined cod_only & !defined nophys
c
c  Transfer transport streamfunction or surface pressure.
c
      do n = nst, nnd
         call get_fld (ncid1,extname,infile,n,imt1,jmt1,1,baro,fld)
         if (ismsk1) then
            if (issfn) then
               call psi_under (imt1,jmt1,fld,mask,max2,wk)
            else
               call smooth_under (imt1,jmt1,1,fld,mask,1,max2,wk)
            endif
         endif
         call mapfld (imt1,jmt1,1,fld,imt2,jmt2,fld2)
         if (ismsk2.and.issfn) call transunder (imt2,jmt2,fld2)
         if (n.eq.nst)
     &      call wrt_fld (ncid2,extname,outfile,1,imt2,jmt2,1,baro,fld2)
         if (dobndy) then
            call get_bndy (0,imt2,jmt2,ijmx,1,fld2,fld)
            call wrt_bdy (ncid2,bxname,outfile,(n+1-nst),imt2,jmt2,ijmx,
     &                                                       1,baro,fld)
         endif
      end do
c
c  Transfer barotropic vorticity tendency (BCs only).
c
      if (ispe.and.issfn.and.dobndy) then
         do n = nst, nnd
            call get_fld (ncid1,'qbar',infile,n,imt1,jmt1,1,baro,fld)
            if (ismsk1)
     &         call smooth_under (imt1,jmt1,1,fld,vmsk,0,max2,wk)
            call mapfld (imt1,jmt1,1,fld,imt2,jmt2,fld2)
            call get_bndy (1,imt2,jmt2,ijmx,1,fld2,fld)
            call wrt_bdy (ncid2,'qbry',outfile,(n+1-nst),imt2,jmt2,ijmx,
     &                                                       1,baro,fld)
         end do
      endif
c
c  Transfer baroclinic velocity.
c
      do n = nst, nnd
         do velind = 1, 2
            call get_fld (ncid1,'vclin',infile,n,imt1,jmt1,lev1,velind,
     &                                                              fld)
# ifdef nestvclin
            call scalvclin (imt1,jmt1,lev1,fld,dzin,fld2,'Multiply')
# endif
            if (ismsk1)
     &         call smooth_under (imt1,jmt1,lev1,fld,vmsk,2,max2,wk)
            call mapfld (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
# ifdef nestvclin
            call scalvclin (imt2,jmt2,lev2,fld,dzout,fld2,'Divide')
# endif
            if (n.eq.nst)
     &         call wrt_fld (ncid2,'vclin',outfile,1,imt2,jmt2,lev2,
     &                                                      velind,fld2)
            if (dobndy) then
               call get_bndy (2,imt2,jmt2,ijmx,lev2,fld2,fld)
               call wrt_bdy (ncid2,'vbry',outfile,(n+1-nst),imt2,jmt2,
     &                                             ijmx,lev2,velind,fld)
            endif
         end do
      end do
c
c  Transfer barotropic velocity.  Treat vector dimension as depth
c  dimension of length 2.
c
      if (.not.issfn) then
         do n = nst, nnd
            call get_fld (ncid1,'vbaro',infile,n,imt1,jmt1,2,genscl,fld)
            if (ismsk1)
     &         call smooth_under (imt1,jmt1,2,fld,vmsk,2,max2,wk)
            call mapfld (imt1,jmt1,2,fld,imt2,jmt2,fld2)
            if (n.eq.nst)
     &         call wrt_fld (ncid2,'vbaro',outfile,1,imt2,jmt2,2,genscl,
     &                                                             fld2)
            if (dobndy) then
               call get_bndy (2,imt2,jmt2,ijmx,2,fld2,fld)
               call wrt_bdy (ncid2,'vbbry',outfile,(n+1-nst),imt2,jmt2,
     &                                                ijmx,2,genscl,fld)
            endif
         end do
      endif
c
#endif
c-----------------------------------------------------------------------
c  Close netCDF files.
c-----------------------------------------------------------------------
c
      call ncclos (ncid1,err)
      if (err.eq.0) then
         ncflg1 = 0
        else
         write (6,120) outfile
         call udiejoe ('FAKENEST')
      end if
c
      call ncclos (ncid2,err)
      if (err.eq.0) then
         ncflg2 = 0
        else
         write (6,120) infile
         call udiejoe ('FAKENEST')
      end if
c
      write (6,130)
c
      stop
c
#ifdef sunfpe
  10  format (/'+++ Warning:  ieee_handler cannot set my_handler'/)
#endif
  20  format (/'Enter name of ',a,' file: ')
  30  format (a)
  40  format(/'*** Error:  FAKENEST - unable to open file:'/12x,1h",a,
     &                                                              1h")
  50  format (/'*** Error:  FAKENEST - incompatible dimensions:'/12x,
     &                    'file1 ',a,' = ',i10/12x,'file2 ',a,' = ',i10)
  60  format (/'*** Error:  FAKENEST - too many grid points:'/12x,
     &          'im*jm*nlev = ',i10/17x,'maxpt = ',i10/12x,'Recompile ',
     &        'FAKENEST with the larger value for maxpt and try again.')
  70  format (/'*** Error:  FAKENEST - too many grid points:'/12x,
     &          'im*jm = ',i10/17x,'max2 = ',i10/12x,'Recompile ',
     &        'FAKENEST with the larger value for max2 and try again.')
  80  format (/'*** Error:  FAKENEST - input/output files have differen'
     &        ,'t external formulations.')
  90  format (/'Enter starting time index  [1, ',i4,']: ')
 100  format (/'Enter ending time index    [',i4,', ',i4,']: ',$)
 110  format (/'Do you want to update the boundaries? (y|n): ',$)
 120  format (/'*** Error:  FAKENEST - unable to close file:'/12x,1h",a,
     &                                                              1h")
 130  format (/'FAKENEST DONE')
c
      end
