      subroutine get_dim (ncid,dimname,filename,dim)
c
c-----------------------------------------------------------------------
c     This routine gets the dimension size from the supplied netCDF    |
c     file.                                                            |
c                                                                      |
c            Calls:  udiejoe                                           |
c     netCDF Calls:  ncdid, ncdinq                                     |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c        ncid.......Integer.  NetCDF file identifier.                  |
c        dimname....Character.  Name of requested dimension.           |
c        filename...Character.  Name of NetCDF file (for error msgs.)  |
c                                                                      |
c     Output:                                                          |
c                                                                      |
c        dim........Integer.  The size of the dimension.               |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Global data.                                                     |
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      integer dim,dimid,err,ncid
      character*80 dummy
      character*(*) dimname,filename
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Get dimension identifier for netCDF file.                        |
c-----------------------------------------------------------------------
c
      dimid = ncdid (ncid,dimname,err)
c
      if (err.ne.0) then
         write (6,10) dimname,filename
         call udiejoe ('GET_DIM')
      end if
c
c-----------------------------------------------------------------------
c     Get dimension size from netCDF file.                             |
c-----------------------------------------------------------------------
c
      call ncdinq (ncid,dimid,dummy,dim,err)
c
      if (err.ne.0) then
         write (6,20) dimname,filename
         call udiejoe ('GET_DIM')
      end if
c
      return
c
 10   format (/'*** Error:  GET_DIM - unable to find dimension ',1h",a,
     &                                    1h",' in file:'/12x,1h",a,1h")
 20   format (/'*** Error:  GET_DIM - unable to read dimension ',1h",a,
     &                                    1h",' in file:'/12x,1h",a,1h")
c
      end
