      subroutine get_ivec (ncid,varname,filename,nvec,vec)
c
c-----------------------------------------------------------------------
c     This routine gets a vector variable from the given netCDF file.  |
c                                                                      |
c            Calls:  udiejoe                                           |
c     netCDF Calls:  ncvgt, ncvid                                      |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c        ncid.......Integer.  NetCDF file identifier.                  |
c        varname....Character.  Variable name.                         |
c        filename...Character.  Name of NetCDF file.                   |
c        nvec.......Integer.  Number of data points in vector.         |
c                                                                      |
c     Output                                                           |
c                                                                      |
c        vec........Integer.  Extracted vector variable.               |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Global data.                                                     |
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      integer err,ncid,nvec,varid
      integer       vec(nvec)
      character*(*) varname,filename
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Get variable identifier.                                         |
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,varname,err)
c
      if (err.ne.0) then
         write (6,10) varname,filename
         call udiejoe ('GET_FLD')
      end if
c
c-----------------------------------------------------------------------
c     Read variable.                                                   |
c-----------------------------------------------------------------------
c
      call ncvgt (ncid,varid,1,nvec,vec,err)
c
      if (err.ne.0) then
         write (6,20) varname,filename
         call udiejoe ('GET_FLD')
      end if
c
      return
c
 10   format (/'*** Error:  GET_FLD - unable to find variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
 20   format (/'*** Error:  GET_FLD - unable to read variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
c
      end
