      subroutine get_sclr (ncid,varname,filename,indx,var)
c
c-----------------------------------------------------------------------
c     This routine gets a scalar variable from the given netCDF file.  |
c                                                                      |
c            Calls:  udiejoe                                           |
c     netCDF Calls:  ncvgt1, ncvid                                     |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c        ncid.......Integer.  NetCDF file identifier.                  |
c        varname....Character.  Variable name.                         |
c        filename...Character.  Name of NetCDF file.                   |
c        indx.......Integer.  Index of variable to extract.            |
c                                                                      |
c     Output                                                           |
c                                                                      |
c        var........Real.  Extracted scalar variable.                  |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Global data.                                                     |
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      real    var
      integer       err,indx,ncid,varid
      character*(*) varname,filename
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Get variable identifier.                                         |
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,varname,err)
c
      if (err.ne.0) then
         write (6,10) varname,filename
         call udiejoe ('GET_SCLR')
      end if
c
c-----------------------------------------------------------------------
c     Read variable.                                                   |
c-----------------------------------------------------------------------
c
      call ncvgt1 (ncid,varid,indx,var,err)
c
      if (err.ne.0) then
         write (6,20) varname,filename
         call udiejoe ('GET_SCLR')
      end if
c
      return
c
 10   format (/'*** Error:  GET_SCLR - unable to find variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
 20   format (/'*** Error:  GET_SCLR - unable to read variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
c
      end
