      subroutine julian (d,m,iy,j,f)
c
c=======================================================================
c  This routine converts a gregorian calendar date into a julian     ===
c  date.                                                             ===
c                                                                    ===
c  Input:                                                            ===
c                                                                    ===
c     d....day of the month, including fractional part.   (real)     ===
c     m....month of the year.                             (integer)  ===
c     iy...year in gregorian calendar.                    (integer)  ===
c                                                                    ===
c  Output:                                                           ===
c                                                                    ===
c     j....modified julian day.                           (integer)  ===
c     f....fractional day.  Starts at noon.               (real)     ===
c                                                                    ===
c  Calls:  INTBAS                                                    ===
c                                                                    ===
c=======================================================================
c
      integer m,iy,j,j1,id
      integer intbas
      real    d,f,s,a
      real    c0,c1,c1p75,c275,c9,p01,p5,p75,r9,r12
c
      parameter (c0=0.0, c1=1.0, c1p75=1.75, c275=275.0, c9=9.0,
     &           p01=0.01, p5=0.5, p75=0.75, r9=c1/c9, r12=c1/12.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      id=d
      j=-intbas(c1p75*(intbas((m+c9)*r12) + iy))
      s=sign(c1,float(m-9))
      a=abs(m-9)
      j1=intbas(iy+s*intbas(a/7))
      j1=-intbas((intbas(j1*p01)+c1)*p75)
      j=j+intbas(c275*m*r9) + id + j1
      j=j+1721027+2+367*iy
c
      f=d-id-p5
      if(f.lt.c0)j=j-1
      if(f.lt.c0)f=f+c1
c
      return
      end
