      program lagr_conv
c
c-----------------------------------------------------------------------
c     This program converts Lagrangian drifter netCDF output into the  |
c     ASCII format understood by the plotting codes.                   |
c                                                                      |
c            Calls:  length, udiejoe                                   |
c     netCDF Calls:  ncagt, ncclos, ncdid, ncdinq, ncopn, ncvgt,       |
c                    ncvgtc, ncvid                                     |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Global data.                                                     |
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
#include <netstat.h>
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      real    c1,eps,fillval,lagpos(3),lagtime,small,spval
      integer count(3),err,lenbgn,lenend,lenid,nd,ndrift,nt,ntime,
     &             posid,slen,start(3),timid,varid
      character*80 blank,infile,lagid,outfile
c
      parameter (spval=999.0, eps=1.19209 28955 07812 5 E-07, c1=1.0,
     &           small=eps*(c1+eps))
c
      data ncflg1,ncflg2 /2*0/
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Create a blank character string.                                 |
c-----------------------------------------------------------------------
c
      do nt = 1, 80
         blank(nt:nt) = ' '
      end do
c
c-----------------------------------------------------------------------
c     Read in input and output file names.                             |
c-----------------------------------------------------------------------
c
      write (6,20) 'input netCDF'
      read (5,30) infile
c
      write (6,20) 'output ASCII'
      read (5,30) outfile
c
c-----------------------------------------------------------------------
c     Open files.                                                      |
c-----------------------------------------------------------------------
c
      call ncpopt (ncverbos)
c
      ncid1 = ncopn (infile,ncnowrit,err)
      if (err.eq.0) then
         ncflg1 = 1
        else
         call length (infile,slen,lenbgn,lenend)
         write (6,40) infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
c
      open (13, file=outfile, status='unknown', iostat=err)
      if (err.ne.0) then
         call length (outfile,slen,lenbgn,lenend)
         write (6,40) outfile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
c
c-----------------------------------------------------------------------
c     Get size data, identifiers and flag data.                        |
c-----------------------------------------------------------------------
c
      varid = ncdid (ncid1,'time',err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,50) 'time',infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
      call ncdinq (ncid1,varid,lagid,ntime,err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,60) 'time',infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
c
      varid = ncdid (ncid1,'drifter',err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,50) 'drifter',infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
      call ncdinq (ncid1,varid,lagid,ndrift,err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,60) 'drifter',infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
c
      varid = ncdid (ncid1,'lenid',err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,50) 'lenid',infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
      call ncdinq (ncid1,varid,lagid,lenid,err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,60) 'lenid',infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
c
      timid = ncvid (ncid1,'trk_time',err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,70) 'trk_time',infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
      call ncagt (ncid1,timid,'_FillValue',fillval,err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,80) '_FillValue',infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
c
      posid = ncvid (ncid1,'trk_pos',err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,70) 'trk_pos',infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
c
      varid = ncvid (ncid1,'trk_id',err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,70) 'trk_id',infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
c
c-----------------------------------------------------------------------
c     Loop over all drifters.  For each drifter, loop over all times.  |
c     For each time it's present, write its position data into the     |
c     the ASCII file.                                                  |
c-----------------------------------------------------------------------
c
      do 10 nd = 1, ndrift
c
         start(1) = 1
         start(2) = nd
         count(1) = lenid
         count(2) = 1
         lagid = blank
         call ncvgtc (ncid1,varid,start,count,lagid,80,err)
         if (err.ne.0) then
            call length (infile,slen,lenbgn,lenend)
            write (6,90) 'trk_id',infile(lenbgn:lenend),nd
            call udiejoe ('LAGR_CONV')
         end if
         call length (lagid,slen,lenbgn,lenend)
         write (13,100) spval,spval,spval,spval,lagid(lenbgn:lenend)
c
         do 10 nt = 1, ntime
c
            start(1) = nd
            start(2) = nt
            count(1) = 1
            count(2) = 1
            call ncvgt (ncid1,timid,start,count,lagtime,err)
            if (err.ne.0) then
               call length (infile,slen,lenbgn,lenend)
               write (6,110) 'trk_time',infile(lenbgn:lenend),nd,nt
               call udiejoe ('LAGR_CONV')
            end if
c
            if ( abs(lagtime-fillval) .gt. small*abs(lagtime) ) then
c
               start(1) = 1
               start(2) = nd
               start(3) = nt
               count(1) = 3
               count(2) = 1
               count(3) = 1
               call ncvgt (ncid1,posid,start,count,lagpos,err)
               if (err.ne.0) then
                  call length (infile,slen,lenbgn,lenend)
                  write (6,110) 'trk_time',infile(lenbgn:lenend),nd,nt
                  call udiejoe ('LAGR_CONV')
               end if
               write (13,120) lagpos(2),lagpos(1),-lagpos(3),lagtime
c
            end if
 10   continue
c
      write (13,100) spval,spval,spval,spval,'END'
c
c-----------------------------------------------------------------------
c     Close files and terminate.                                       |
c-----------------------------------------------------------------------
c
      call ncclos (ncid1,err)
      if (err.ne.0) then
         call length (infile,slen,lenbgn,lenend)
         write (6,130) infile(lenbgn:lenend)
         call udiejoe ('LAGR_CONV')
      end if
c
      close (13)
c
      write (6,140)
c
      stop
c
 20   format (/'Enter ',a,' file name: ',$)
 30   format (a)
 40   format (/'*** Error:  LAGR_CONV - unable to open file:'/12x,1h",
     &                                                            a,1h")
 50   format (/'*** Error:  LAGR_CONV - unable to find dimension ',1h",
     &                                  a,1h",' in file:'/12x,1h",a,1h")
 60   format (/'*** Error:  LAGR_CONV - unable to inquire about',
     &                ' dimension ',1h",a,1h",' in file:'/12x,1h",a,1h")
 70   format (/'*** Error:  LAGR_CONV - unable to find variable ',1h",
     &                                  a,1h",' in file:'/12x,1h",a,1h")
 80   format (/'*** Error:  LAGR_CONV - unable to inquire about',
     &                ' attribute ',1h",a,1h",' in file:'/12x,1h",a,1h")
 90   format (/'*** Error:  LAGR_CONV - unable to read variable ',1h",
     &      a,1h",' in file:'/12x,1h",a,1h"/12x,'drifter number:  ',i10)
100   format (f8.4,1x,f9.4,1x,f9.2,1x,f10.4,1x,a)
110   format (/'*** Error:  LAGR_CONV - unable to read variable ',1h",
     &      a,1h",' in file:'/12x,1h",a,1h"/12x,'drifter number:  ',i10/
     &                                          12x,'time index:  ',i10)
120   format (f8.4,1x,f9.4,1x,f9.2,1x,f10.4)
130   format (/'*** Error:  LAGR_CONV - unable to close file:'/12x,1h",
     &                                                            a,1h")
140   format (/'LAGR_CONV DONE')
c
      end
