      subroutine zero_fld (nx,ny,nz,var)
c
c-----------------------------------------------------------------------
c     This routine zeroes a field variable.                            |
c                                                                      |
c            Calls:  none                                              |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c        nx.........Integer.  Number of x gridpoints.                  |
c        ny.........Integer.  Number of y gridpoints.                  |
c        nz.........Integer.  Number of z gridpoints.                  |
c                      (nz<0 flags a 2D field)                         |
c                                                                      |
c     Output                                                           |
c                                                                      |
c        var........Real.  Extracted field variable.                   |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      integer i,j,k,nx,ny,nz
      real    c0
      real    var(nx,ny,nz)
c
      parameter (c0=0.0)
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Get variable identifier.                                         |
c-----------------------------------------------------------------------
c
      do 10 k = 1, nz
      do 10 j = 1, ny
      do 10 i = 1, nx
         var(i,j,k) = c0
  10  continue
c
      return
      end
