      subroutine chg_val (nx,ny,nz,vals,ip,jp,act_val,wkmsk,nchg,mxwk,
     &                                                        ichg,jchg)
c
c-----------------------------------------------------------------------
c     This routine attempts to replace the indicated value with an     |
c     average of its unmasked neighbors.                               |
c-----------------------------------------------------------------------
c
      integer act_val,ip,jp,k,mxwk,nchg,nnew,nx,ny,nz
      integer ichg(mxwk),jchg(mxwk),wkmsk(nx,ny)
      real    c0,new_val(100),vals(nz,nx,ny)
c
      parameter (c0 = 0.0)
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Attempt to construct an average of unmasked neighbors.
c-----------------------------------------------------------------------
c
      do k = 1, nz
         new_val(k) = c0
      enddo
      nnew    = 0
c
c     ------------------
c     --- Row below. ---
c     ------------------
c
      if (jp.gt.1) then
c
         if (ip.gt.1) then
            if (wkmsk(ip-1,jp-1).eq.act_val) then
               nnew    = 1
               do k = 1, nz
                  new_val(k) = vals(k,ip-1,jp-1)
               enddo
            end if
         end if
c
         if (wkmsk(ip,jp-1).eq.act_val) then
            nnew    = nnew + 1
            do k = 1, nz
               new_val(k) = new_val(k) + vals(k,ip,jp-1)
            enddo
         end if
c
         if (ip.lt.nx) then
            if (wkmsk(ip+1,jp-1).eq.act_val) then
               nnew    = nnew + 1
               do k = 1, nz
                  new_val(k) = new_val(k) + vals(k,ip+1,jp-1)
               enddo
            end if
         end if
c
      end if
c
c     ------------------
c     --- Row above. ---
c     ------------------
c
      if (jp.lt.ny) then
c
         if (ip.gt.1) then
            if (wkmsk(ip-1,jp+1).eq.act_val) then
               do k = 1, nz
                  new_val(k) = new_val(k) + vals(k,ip-1,jp+1)
               enddo
               nnew    = nnew + 1
            end if
         end if
c
         if (wkmsk(ip,jp+1).eq.act_val) then
            do k = 1, nz
               new_val(k) = new_val(k) + vals(k,ip,jp+1)
            enddo
            nnew    = nnew + 1
         end if
c
         if (ip.lt.nx) then
            if (wkmsk(ip+1,jp+1).eq.act_val) then
               do k = 1, nz
                  new_val(k) = new_val(k) + vals(k,ip+1,jp+1)
               enddo
               nnew    = nnew + 1
            end if
         end if
c
      end if
c
c     --------------------
c     --- Current row. ---
c     --------------------
c
      if (ip.gt.1) then
         if (wkmsk(ip-1,jp).eq.act_val) then
            do k = 1, nz
               new_val(k) = new_val(k) + vals(k,ip-1,jp)
            enddo
            nnew    = nnew + 1
         end if
      end if
c
      if (ip.lt.nx) then
         if (wkmsk(ip+1,jp).eq.act_val) then
            do k = 1, nz
               new_val(k) = new_val(k) + vals(k,ip+1,jp)
            enddo
            nnew    = nnew + 1
         end if
      end if
c
c-----------------------------------------------------------------------
c     If any unmasked neighbors were found, replace value and mark
c     indicators.
c-----------------------------------------------------------------------
c
      if (nnew.gt.0) then
c
         do k = 1, nz
            vals(k,ip,jp) = new_val(k)/float(nnew)
         enddo
c
         nchg       = nchg + 1
         ichg(nchg) = ip
         jchg(nchg) = jp
c
      end if
c
      return
      end
