      subroutine exttype (ncid,filename,issfn,varname)
c
c=======================================================================
c                                                                    ===
c  This routine gets determines the type of external mode for the    ===
c  given file.                                                       ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NCID.......NetCDF file identifier.             (integer)       ===
c     FILENAME...Name of NetCDF file.                (string)        ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     ISSFN......External type flag.                       (logical) ===
c                   [.true.]   transport streamfunction.             ===
c                   [.false.]  surface pressure.                     ===
c     VARNAME....Variable name for trnspt/srf.press.       (string)  ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     LENGTH,  UDIEJOE                                               ===
c                                                                    ===
c     netCDF:  NCVID                                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer err,ncid,sbn,sln,snd,varid,vbn,vln,vnd
      logical       issfn
      character*(*) filename,varname
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Get variable identifier.
c-----------------------------------------------------------------------
c
      varname = 'srfpress'
      call length (varname,vln,vbn,vnd)
      varid = ncvid (ncid,varname(vbn:vnd),err)
      issfn = err .ne. 0
c
      if (issfn) then
         varname = 'pbar'
         call length (varname,vln,vbn,vnd)
         varid = ncvid (ncid,varname(vbn:vnd),err)
c
         if (err.ne.0) then
            call length (filename,sln,sbn,snd)
            write (6,10) 'pbar/srfpress',filename(sbn:snd)
            call udiejoe ('EXTTYPE')
         end if
      end if
c
      return
c
 10   format (/'*** Error:  EXTTYPE - unable to find variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
c
      end
