      subroutine get_bndy (type,nx,ny,nxymx,nz,fld,bndyfld)
c
c=======================================================================
c                                                                    ===
c  This subroutine pulls boundary conditions off of the given field. ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     TYPE......Type of boundary condition to extract.   (integer)   ===
c                  [0] transport streamfunction                      ===
c                  [1] barotropic vorticity                          ===
c                  [2] velocity                                      ===
c                  [3] tracer                                        ===
c     NX........The number of zonal grid points.         (integer)   ===
c     NY........The number of meridional grid points.    (integer)   ===
c     NXYMX.....max ( nx , ny ).                         (integer)   ===
c     NZ........The number of levels.                    (integer)   ===
c     FLD.......The volume field.                        (real array)===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     BNDYFLD...The boundary field.   (real array)                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer west,south,east,north
      parameter (west=1, south=2, east=3, north=4)
c
      integer bindx,i,j,k,n,nx,nxymx,ny,nz,type
      integer dbe(3),dbn(3),dbs(3),dbw(3)
      real    fld(nz,nx,ny),bndyfld(nz,nxymx,4,3)
c
      data dbe /0,-1,-2/
      data dbn /0,-1,-2/
      data dbs /0, 1, 2/
      data dbw /0, 1, 2/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Extract western boundary.
c-----------------------------------------------------------------------
c
      if (type.ne.1) then
         bindx = 1
        else
         bindx = 2
      end if
c
      do 10 n = 1,3
         do 10 k = 1, nz
            do 10 j = 1, ny
               bndyfld(k,j,west,n) = fld(k,bindx+dbw(n),j)
 10   continue
c
c-----------------------------------------------------------------------
c  Extract eastern boundary.
c-----------------------------------------------------------------------
c
      if ((type.ne.1) .and. (type.ne.2)) then
         bindx = nx
        else
         bindx = nx-1
      end if
c
      do 20 n = 1, 3
         do 20 k = 1, nz
            do 20 j = 1, ny
               bndyfld(k,j,east,n) = fld(k,bindx+dbe(n),j)
 20   continue
c
c-----------------------------------------------------------------------
c  Extract southern boundary.
c-----------------------------------------------------------------------
c
      if (type.ne.1) then
         bindx = 1
        else
         bindx = 2
      end if
c
      do 30 n = 1, 3
         do 30 k = 1, nz
            do 30 i = 1, nx
               bndyfld(k,i,south,n) = fld(k,i,bindx+dbs(n))
 30   continue
c
c-----------------------------------------------------------------------
c  Extract northern boundary.
c-----------------------------------------------------------------------
c
      if (type.ne.0) then
         bindx = ny-1
        else
         bindx = ny
      end if
c
      do 40 n = 1, 3
         do 40 k = 1, nz
            do 40 i = 1, nx
               bndyfld(k,i,north,n) = fld(k,i,bindx+dbn(n))
 40   continue
c
      return
      end
