      subroutine get_vort (ncid,filename,timind,ntim,nx,ny,baro,xymrat,
     &                     yxmrat,ismsk,mask,iwk,ztd,rwk)
c
c=======================================================================
c                                                                    ===
c  This routine gets a field variable from the given netCDF file.    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NCID.......NetCDF file identifier.              (integer)      ===
c     FILENAME...Name of NetCDF file.                 (string)       ===
c     TIMIND.....Time index of variable to extract.   (integer)      ===
c     NTIM.......Total number of time levels.         (integer)      ===
c     NX.........Number of x gridpoints.              (integer)      ===
c     NY.........Number of y gridpoints.              (integer)      ===
c     BARO.......Barotropic field flag.               (integer)      ===
c     XYMRAT.....XoverY metric ratio (w/ hv & dy).    (real array)   ===
c     YXMRAT.....YoverX metric ratio (w/ hv & dx).    (real array)   ===
c     ISMSK......Flag for whether model is masked.    (logical)      ===
c     MASK.......Land mask.                           (integer array)===
c     IWK........Work space.                          (integer array)===
c     RWK........Work space.                          (real array)   ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     ZTD........Vorticity tendency.                  (real array)   ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     GET_FLD,  GET_SCLR,  PSI_UNDER                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer baro,i,j,ncid,ntim,nx,ny,timind
      integer iwk(nx,ny),mask(nx,ny)
      logical first,ismsk
      real    c1,c2,c3,c4,p25,r2dt
      real          rwk(nx,ny),xymrat(nx,ny),yxmrat(nx,ny),ztd(nx,ny)
      character*(*) filename
c
      parameter (c1=1.0, c2=2.0, c3=3.0, c4=4.0, p25=0.25)
c
      save first,r2dt
c
      data first /.true./
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Get temporal spacing of fields.
c-----------------------------------------------------------------------
c
      if (first) then
         call get_sclr (ncid,'time',filename,2,r2dt)
         r2dt = c1/(c2*r2dt)
         first = .false.
      endif
c
c-----------------------------------------------------------------------
c  Get transport streamfunction tendency.
c-----------------------------------------------------------------------
c
      if ((timind.gt.1).and.(timind.lt.ntim)) then
c
c  Centered difference
c
         call get_fld (ncid,'pbar',filename,(timind+1),nx,ny,1,baro,ztd)
         if (ismsk) call psi_under (nx,ny,ztd,mask,(nx*ny),iwk)
         call get_fld (ncid,'pbar',filename,(timind-1),nx,ny,1,baro,rwk)
         if (ismsk) call psi_under (nx,ny,rwk,mask,(nx*ny),iwk)
c
       elseif (timind.eq.1) then
c
c  Left-end difference
c
         call get_fld (ncid,'pbar',filename,1,nx,ny,1,baro,ztd)
         if (ismsk) call psi_under (nx,ny,ztd,mask,(nx*ny),iwk)
         call get_fld (ncid,'pbar',filename,2,nx,ny,1,baro,rwk)
         if (ismsk) call psi_under (nx,ny,rwk,mask,(nx*ny),iwk)
         do 10 j = 1, ny
         do 10 i = 1, nx
            ztd(i,j) = c4*rwk(i,j) - c3*ztd(i,j)
  10     continue
         call get_fld (ncid,'pbar',filename,3,nx,ny,1,baro,rwk)
         if (ismsk) call psi_under (nx,ny,rwk,mask,(nx*ny),iwk)
c
       elseif (timind.eq.ntim) then
c
c  Right-end difference
c
         call get_fld (ncid,'pbar',filename,ntim,nx,ny,1,baro,ztd)
         if (ismsk) call psi_under (nx,ny,ztd,mask,(nx*ny),iwk)
         call get_fld (ncid,'pbar',filename,(ntim-1),nx,ny,1,baro,rwk)
         if (ismsk) call psi_under (nx,ny,rwk,mask,(nx*ny),iwk)
         do 20 j = 1, ny
         do 20 i = 1, nx
            rwk(i,j) = c4*rwk(i,j) - c3*ztd(i,j)
  20     continue
         call get_fld (ncid,'pbar',filename,(ntim-2),nx,ny,1,baro,ztd)
         if (ismsk) call psi_under (nx,ny,ztd,mask,(nx*ny),iwk)
c
      end if
c
c  Final part of differencing.
c
      do 30 j = 1, ny
      do 30 i = 1, nx
         rwk(i,j) = (ztd(i,j)-rwk(i,j))*r2dt
  30  continue
c
c-----------------------------------------------------------------------
c  Get barotropic vorticity tendency.
c-----------------------------------------------------------------------
c
c  Take laplacian of transport streamfunction tendency, with constant
c  extrapolation to streamfn boundaries.
c
      do 50 j=2,ny-1
        do 40 i=2,nx-1
           ztd(i,j)=p25*(yxmrat(i  ,j  )*((rwk(i+1,j+1)-rwk(i  ,j+1))+
     &                                    (rwk(i+1,j  )-rwk(i  ,j  )))
     &                  -yxmrat(i-1,j  )*((rwk(i  ,j+1)-rwk(i-1,j+1))+
     &                                    (rwk(i  ,j  )-rwk(i-1,j  ))))
     &             +p25*(yxmrat(i  ,j-1)*((rwk(i+1,j  )-rwk(i  ,j  ))+
     &                                    (rwk(i+1,j-1)-rwk(i  ,j-1)))
     &                  -yxmrat(i-1,j-1)*((rwk(i  ,j  )-rwk(i-1,j  ))+
     &                                    (rwk(i  ,j-1)-rwk(i-1,j-1))))
     &             +p25*(xymrat(i  ,j  )*((rwk(i+1,j+1)-rwk(i+1,j  ))+
     &                                    (rwk(i  ,j+1)-rwk(i  ,j  )))
     &                  -xymrat(i  ,j-1)*((rwk(i+1,j  )-rwk(i+1,j-1))+
     &                                    (rwk(i  ,j  )-rwk(i  ,j-1))))
     &             +p25*(xymrat(i-1,j  )*((rwk(i  ,j+1)-rwk(i  ,j  ))+
     &                                    (rwk(i-1,j+1)-rwk(i-1,j  )))
     &                  -xymrat(i-1,j-1)*((rwk(i  ,j  )-rwk(i  ,j-1))+
     &                                    (rwk(i-1,j  )-rwk(i-1,j-1))))
  40    continue
        ztd(1,j)  = ztd(2,j)
        ztd(nx,j) = ztd(nx-1,j)
  50  continue
c
      do 60 i = 1, nx
        ztd(i,1)  = ztd(i,2)
        ztd(i,ny) = ztd(i,ny-1)
  60  continue
c
c Currently have put all dx, dy into "metric ratios".  Ideally
c should extract 1 for differentiating between (e.g.) dxu, dxt
c (see below)
c
c Hub(i,j) = [(pb(i,j)-pb(i,j+1)) + (pb(i+1,j)-pb(i+1,j+1))]/(2dy*vmety(i,j))
c
c Hvb(i,j) = [(pb(i+1,j)-pb(i,j)) + (pb(i+1,j+1)-pb(i,j+1))]/(2dx*vmetx(i,j))
c
c dtvort = { [(vb(i,j-1)*vmty(i,j-1)-vb(i-1,j-1)*vmty(i-1,j-1)) +
c             (vb(i,j)*vmty(i,j)-vb(i-1,j)*vmty(i-1,j))]
c            /(2dx*dt*tmtx(i,j)*tmty(i,j))
c           +[(ub(i,j)*vmtx(i,j)-ub(i,j-1)*vmtx(i,j-1)) +
c             (ub(i-1,j)*vmtx(i-1,j)-ub(i-1,j-1)*vmtx(i-1,j-1))]
c            /(2dy*dt*tmtx(i,j)*tmty(i,j)) }
c
      return
      end
