      subroutine mapfld (nx1,ny1,nz,fld1,nx2,ny2,fld2)
c
c-----------------------------------------------------------------------
c     This routine maps field 1 onto field 2 .                         |
c                                                                      |
c     Calls:  BES1D, LL2XY, XY2LL                                      |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c        nx1....The number of x-grid points in field 1.                |
c        ny1....The number of y-grid points in field 1.                |
c        nz.....The number of model levels.                            |
c        fld1...The field to extract from.                             |
c        nx2....The number of x-grid points in field 2.                |
c        ny2....The number of y-grid points in field 2.                |
c                                                                      |
c     Output:                                                          |
c                                                                      |
c        fld2...The extracted field.                                   |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Global data.                                                     |
c-----------------------------------------------------------------------
c
#include <domsdat.h>
c
c-----------------------------------------------------------------------
c     Local data.                                                      |
c-----------------------------------------------------------------------
c
      integer i,i1,i2,i3,i4,ibry,ix,iy,j,j1,j2,j3,j4,jbry,k,nx1,ny1,nz,
     &        nx2,ny2
      real c2,f1,f2,f3,f4,fld1(nz,nx1,ny1),fld2(nz,nx2,ny2),lon,lat,s,t,
     &     x,y
      real bes1d
c
      parameter (c2=2.0)
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Subsample larger domain onto smaller.                            |
c-----------------------------------------------------------------------
c
      do 20 j = 1, ny2
      do 20 i = 1, nx2
c
c        -------------------------------------------
c        --- Convert grid2 point to grid1 point. ---
c        -------------------------------------------
c
         x = i
         y = j
         call xy2ll (x,y,crd2,nx2,ny2,dx2,dy2,lonc2,latc2,dlx2,dly2,
     &               thet2,lon,lat)
         call ll2xy (lon,lat,crd1,nx1,ny1,dx1,dy1,lonc1,latc1,dlx1,dly1,
     &               thet1,x,y)
C    &                                                                 ^
c
c        --------------------------------------------
c        --- Compute indices for 4x4 data window. ---
c        --------------------------------------------
c
         ix=int(x)
         iy=int(y)
c
         ibry=0
         jbry=0
         i1=ix-1
         i2=ix
         i3=ix+1
         i4=ix+2
         j1=iy-1
         j2=iy
         j3=iy+1
         j4=iy+2
c
c        -------------------------
c        --- Check boundaries. ---
c        -------------------------
c
         if(x.lt.c2) then
           ibry=1
           i1=2
         elseif(x.ge.float(nx1-1)) then
           ibry=2
           i4=nx1-1
         endif
c
         if(y.lt.c2) then
           jbry=1
           j1=2
         elseif(y.ge.float(ny1-1)) then
           jbry=2
           j4=ny1-1
         endif
c
c        --------------------
c        --- Interpolate. ---
c        --------------------
c
         s=x-ix
         t=y-iy
c
         do 10 k = 1, nz
c
#ifndef bilin
            f1 = bes1d (t,fld1(k,i1,j1),fld1(k,i1,j2),fld1(k,i1,j3),
     &                                               fld1(k,i1,j4),jbry)
            f2 = bes1d (t,fld1(k,i2,j1),fld1(k,i2,j2),fld1(k,i2,j3),
     &                                               fld1(k,i2,j4),jbry)
            f3 = bes1d (t,fld1(k,i3,j1),fld1(k,i3,j2),fld1(k,i3,j3),
     &                                               fld1(k,i3,j4),jbry)
            f4 = bes1d (t,fld1(k,i4,j1),fld1(k,i4,j2),fld1(k,i4,j3),
     &                                               fld1(k,i4,j4),jbry)
            fld2(k,i,j) = bes1d (s,f1,f2,f3,f4,ibry)
# else
            f2 = (1-t)*fld1(k,i2,j2) + t*fld1(k,i2,j3)
            f3 = (1-t)*fld1(k,i3,j2) + t*fld1(k,i3,j3)
            fld2(k,i,j) = (1-s)*f2 + s*f3
#endif
 10      continue
 20   continue
c
      return
      end
