      program peout2ass
c
c=======================================================================
c                                                                    ===
c   This program takes the output of a PE model run and overwrites a ===
c   PE_initial assimilation file.                                    ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
#ifndef sunfpe
c     EXTTYPE,  GET_DIM,  GET_FLD,  GET_SCLR,  UDIEJOE,  WRT_FLD,    ===
c     WRT_SCLR                                                       ===
# else
c     EXTTYPE,  GET_DIM,  GET_FLD,  GET_SCLR,  MY_HANDLER,  UDIEJOE, ===
c     WRT_FLD,  WRT_SCLR                                             ===
#endif
c                                                                    ===
c     netCDF:  NCCLOS,  NCOPN                                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
#include <netstat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer trcnd,trcst
#if !defined bioDuse & !defined cod_model
      parameter (trcnd=2)
#elif !defined cod_model
      parameter (trcnd=9)
#else
      parameter (trcnd=10)
#endif
#if !defined nophys & !defined cod_only
      parameter (trcst=1)
#elif !defined cod_only
      parameter (trcst=3)
#else
      parameter (trcst=10)
#endif
c
      real    sec2day
      integer maxpt,genscl,baro
      parameter (maxpt=209*180*16, genscl=0, baro=-1,
     &           sec2day=1.0/86400.0)
c
      real    fld(maxpt),fld2(maxpt),dt,t0
      integer err,ijmx,imt1,imt2,jmt1,jmt2,lev1,lev2,n,nnd,nst,tim0,tim1
     &        ,trcind,velind
#ifdef sunfpe
     &        ,ieeer,my_handler,ieee_handler
#endif
      logical      issfn,pi_issfn
      character*80 outfile,infile,extname
      character*47 trcnam(10)
c
#ifdef sunfpe
      external my_handler
c
#endif
cjad - note that the order of the names must match those in the pemodel
c      and peinitial
c
      data trcnam(1) /'temp                                           '/
      data trcnam(2) /'salt                                           '/
      data trcnam(3) /'NO3                                            '/
      data trcnam(4) /'CELLNO3                                        '/
      data trcnam(5) /'zoo                                            '/
      data trcnam(6) /'NH4                                            '/
      data trcnam(7) /'detritus                                       '/
      data trcnam(8) /'CHL                                            '/
      data trcnam(9) /'CELLNH4                                        '/
      data trcnam(10)/'cod                                            '/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef sunfpe
c-----------------------------------------------------------------------
c  Enable floating point error flags.
c-----------------------------------------------------------------------
c
      ieeer = ieee_handler ('set','common',my_handler)
      if (ieeer .ne. 0) write (6,10)
c
#endif
c-----------------------------------------------------------------------
c  Get netCDF file names.
c-----------------------------------------------------------------------
c
      write (6,20) 'PE output'
      read (5,30) infile
c
      write (6,20) 'PE_initial'
      read (5,30) outfile
c
c-----------------------------------------------------------------------
c  Open netCDF files.
c-----------------------------------------------------------------------
c
      call ncpopt (ncverbos)
c
      ncid1 = ncopn (infile,ncnowrit,err)
      if (err.eq.0) then
         ncflg1 = 1
        else
         write (6,40) infile
         call udiejoe ('PEOUT2ASS')
      end if
c
      ncid2 = ncopn (outfile,ncwrite,err)
      if (err.eq.0) then
         ncflg2 = 1
        else
         write (6,40) outfile
         call udiejoe ('PEOUT2ASS')
      end if
c
c-----------------------------------------------------------------------
c  Find the size of the variables and the length of the time series
c  in both files.
c-----------------------------------------------------------------------
c
      call get_dim (ncid1,'tlon',infile,imt1)
      call get_dim (ncid1,'tlat',infile,jmt1)
      call get_dim (ncid1,'outlev',infile,lev1)
      call get_dim (ncid1,'time',infile,tim1)
c
      call get_dim (ncid2,'tlon',outfile,imt2)
      call get_dim (ncid2,'tlat',outfile,jmt2)
      call get_dim (ncid2,'level',outfile,lev2)
      call get_dim (ncid2,'time',outfile,tim0)
c
c-----------------------------------------------------------------------
c  Check dimension sizes.
c-----------------------------------------------------------------------
c
      if (lev1.ne.lev2) write (6,50) 'nlev',lev1,'nlev',lev2
c
      if ((imt1*jmt1*lev1).gt.maxpt) write (6,60) imt1*jmt1*lev1,maxpt
      if ((imt2*jmt2*lev2).gt.maxpt) write (6,60) imt2*jmt2*lev2,maxpt
c
      if ((lev1.ne.lev2).or.((imt1*jmt1*lev1).gt.maxpt).or.
     &                                  ((imt2*jmt2*lev2).gt.maxpt))
     &   call udiejoe ('PEOUT2ASS')
c
      ijmx = max ( imt2 , jmt2)
c
c-----------------------------------------------------------------------
c  Determine type of external mode.
c-----------------------------------------------------------------------
c
      call exttype (ncid1,infile,issfn,extname)
      call exttype (ncid2,outfile,pi_issfn,extname)
c
      if (issfn.neqv.pi_issfn) then
         write (6,70)
         call udiejoe ('PEOUT2ASS')
      end if
c
c-----------------------------------------------------------------------
c  Inquire about the desired starting time index.
c-----------------------------------------------------------------------
c
      write (6,80) tim1
      read (5,*) nst
c
      write (6,90) nst,tim1
      read (5,*) nnd
c
c-----------------------------------------------------------------------
c  Get initial time.
c-----------------------------------------------------------------------
c
      call get_time0 (ncid1,infile,ncid2,outfile,t0)
c
c-----------------------------------------------------------------------
c  Take fields from PE output and use it for assimilation fields.
c-----------------------------------------------------------------------
#if !defined cod_only & !defined nophys
c
c  Transfer time.
c
      do n = nst, nnd
         call get_sclr (ncid1,'time',infile,n,dt)
         dt = dt*sec2day
         call wrt_sclr (ncid2,'time',outfile,(n+1-nst),t0+dt)
      end do
#endif
c
c  Transfer tracers.
c
      do n = nst, nnd
         do trcind = trcst, trcnd
            call get_fld (ncid1,trcnam(trcind),infile,n,imt1,jmt1,lev1,
     &                                                       genscl,fld)
            call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
            call wrt_fld (ncid2,trcnam(trcind),outfile,(n+1-nst),imt2,
     &                                            jmt2,lev2,genscl,fld2)
         end do
      end do
#if !defined cod_only & !defined nophys
c
c  Transfer transport streamfunction or surface pressure.
c
      do n = nst, nnd
         call get_fld (ncid1,'pbar',infile,n,imt1,jmt1,1,baro,fld)
         call subsam (imt1,jmt1,1,fld,imt2,jmt2,fld2)
         call wrt_fld (ncid2,'pbar',outfile,(n+1-nst),imt2,jmt2,1,baro,
     &                                                             fld2)
      end do
c
c  Transfer baroclinic velocity.
c
      do n = nst, nnd
         do velind = 1, 2
            call get_fld (ncid1,'vclin',infile,n,imt1,jmt1,lev1,velind,
     &                                                              fld)
            call subsam (imt1,jmt1,lev1,fld,imt2,jmt2,fld2)
            call wrt_fld(ncid2,'vclin',outfile,(n+1-nst),imt2,jmt2,lev2,
     &                                                      velind,fld2)
         end do
      end do
c
c  Transfer barotropic velocity.  Treat vector dimension as depth
c  dimension of length 2.
c
      if (.not.issfn) then
         do n = nst, nnd
            call get_fld (ncid1,'vbaro',infile,n,imt1,jmt1,2,genscl,fld)
            call subsam (imt1,jmt1,2,fld,imt2,jmt2,fld2)
            call wrt_fld (ncid2,'vbaro',outfile,(n+1-nst),imt2,jmt2,2,
     &                                                      genscl,fld2)
         end do
      endif
c
#endif
c-----------------------------------------------------------------------
c  Close netCDF files.
c-----------------------------------------------------------------------
c
      call ncclos (ncid1,err)
      if (err.eq.0) then
         ncflg1 = 0
        else
         write (6,100) outfile
         call udiejoe ('PEOUT2ASS')
      end if
c
      call ncclos (ncid2,err)
      if (err.eq.0) then
         ncflg2 = 0
        else
         write (6,100) infile
         call udiejoe ('PEOUT2ASS')
      end if
c
      write (6,110)
c
      stop
c
#ifdef sunfpe
  10  format (/'+++ Warning:  ieee_handler cannot set my_handler'/)
#endif
  20  format (/'Enter name of ',a,' file: ',$)
  30  format (a)
  40  format(/'*** Error:  PEOUT2ASS - unable to open file:'/12x,1h",a,
     &                                                              1h")
  50  format (/'*** Error:  PEOUT2ASS - incompatible dimensions:'/12x,
     &                    'file1 ',a,' = ',i10/12x,'file2 ',a,' = ',i10)
  60  format (/'*** Error:  PEOUT2ASS - too many grid points:'/12x,
     &          'im*jm*nlev = ',i10/17x,'maxpt = ',i10/12x,'Recompile ',
     &       'PEOUT2ASS with the larger value for maxpt and try again.')
  70  format (/'*** Error:  PEOUT2ASS - input/output files have differe'
     &        ,'nt external formulations.')
  80  format (/'Enter starting time index  [1, ',i4,']: ',$)
  90  format (/'Enter ending time index    [',i4,', ',i4,']: ',$)
 100  format (/'*** Error:  PEOUT2ASS - unable to close file:'/12x,1h",a
     &                                                             ,1h")
 110  format (/'PEOUT2ASS  DONE')
c
      end
