      subroutine setcmsk (nx,ny,mask)
c
c-----------------------------------------------------------------------
c  This routine constructs a "coastal" mask, which identifies land/sea |
c  points as well as the corresponding coastal index.                  |
c                                                                      |
c     Calls:  nond                                                     |
c                                                                      |
c     ------                                                           |
c     Input:                                                           |
c     ------                                                           |
c                                                                      |
c     nx........Number of points in x-direction.        (integer)      |
c     ny........Number of points in y-direction.        (integer)      |
c     mask......Land mask.                              (integer array)|
c                                                                      |
c     -------                                                          |
c     Output:                                                          |
c     -------                                                          |
c                                                                      |
c     vals......Values smoothly extended under mask.    (real array)   |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <fnparam.h>
#include <fncoast.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer d,dp,i,im,indx,ip,j,jm,jp,n,nx,ny
      integer mask(nx,ny),wk(max2)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Augment mask with boundary nodes.
c-----------------------------------------------------------------------
c
      do 10 j = 1, ny
         jm = max (j-1, 1)
         jp = min (j+1, ny)
         do 10 i = 1, nx
            im = max (i-1, 1)
            ip = min (i+1, nx)
            n = i + (j-1)*nx
            wk(n) = mask(im,jp)*mask(i,jp)*mask(ip,jp)*
     &              mask(im,j )*mask(i,j )*mask(ip,j )*
     &              mask(im,jm)*mask(i,jm)*mask(ip,jm)
 10   continue
c
c-----------------------------------------------------------------------
c  Loop over all points, updating values under the mask.
c-----------------------------------------------------------------------
c
      do 30 j = 1, ny
      do 30 i = 1, nx
c
         ip = i + (j-1)*nx
c
         if (wk(ip).eq.0) then
c
c           ------------------------------------
c           --- Find nearest boundary point. ---
c           ------------------------------------
c
            dp = (i-icst(1))**2 + (j-jcst(1))**2
            indx = 1
c
            do 20 jm = 1, ncst
            do 20 im = 1, lencst(jm)
               n = im + (jm-1)*mxlncs
               d = (i-icst(n))**2 + (j-jcst(n))**2
               if (d.lt.dp) then
                  indx = jm
                  dp = d
               end if
 20         continue
c
c           ------------------------------------------------------------
c           --- Replace value under mask with nearest boundary value ---
c           ------------------------------------------------------------
c
            cmask(ip) = indx
c
          else
c
c           ---------------------
c           --- Active point. ---
c           ---------------------
c
            cmask(ip) = 0
c
         end if
c
 30   continue
c
      return
      end
