      subroutine smooth_under (nx,ny,nz,vals,mask,act_val,mxwk,wk)
c
c-----------------------------------------------------------------------
c     This routine smoothes the field under its land mask to values    |
c     obtained from averaging the neighboring values.                  |
c                                                                      |
c     Calls:  CHG_VAL                                                  |
c                                                                      |
c     ------                                                           |
c     Input:                                                           |
c     ------                                                           |
c                                                                      |
c     nx........Number of points in x-direction.        (integer)      |
c     ny........Number of points in y-direction.        (integer)      |
c     nz........Number of vertical levels.              (integer)      |
c     vals......Initial values.                         (real array)   |
c     mask......Land mask.                              (integer array)|
c     act_val...Active (sea) value in mask.             (integer)      |
c     mxwk......Leading dimension of wk, min=(nx*ny).   (integer)      |
c     wk........Workspace of size (mxwk,3).             (integer array)|
c                                                                      |
c     -------                                                          |
c     Output:                                                          |
c     -------                                                          |
c                                                                      |
c     vals......Values smoothly extended under mask.    (real array)   |
c-----------------------------------------------------------------------
c
      integer act_val,i,ip,j,mxwk,n,nchg,nx,ny,nz
      integer mask(nx,ny),wk(mxwk,3)
      real    vals(nz,nx,ny)
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
#ifndef ignoremask
c-----------------------------------------------------------------------
c     Initialize list of nodes to be changed.
c-----------------------------------------------------------------------
c
      do 10 j = 1, ny
      do 10 i = 1, nx
         ip = i + (j-1)*nx
         wk(ip,1) = mask(i,j)
 10   continue
c
c-----------------------------------------------------------------------
c     Loop until no more changes are made.
c-----------------------------------------------------------------------
c
      nchg = 1
c
      do 40 while (nchg.gt.0)
c
c        --------------------------
c        --- Set to no changes. ---
c        --------------------------
c
         nchg = 0
c
c        -------------------------------------------------------------
c        --- Loop over all points, trying to change masked values. ---
c        -------------------------------------------------------------
c
         do 20 j = 1, ny
         do 20 i = 1, nx
            ip = i + (j-1)*nx
            if (wk(ip,1).ne.act_val) then
               call chg_val (nx,ny,nz,vals,i,j,act_val,wk(1,1),nchg,mxwk
     &                                                 ,wk(1,2),wk(1,3))
            end if
 20      continue
c
c        ------------------------------------
c        --- Unmask newly changed points. ---
c        ------------------------------------
c
         do 30 n = 1, nchg
            ip = wk(1,2) + (wk(1,3)-1)*nx
            wk(ip,1) = act_val
 30      continue
c
 40   continue
c
#endif
      return
      end
