      subroutine subsam (nx1,ny1,nz,fld1,nx2,ny2,fld2)
c
c-----------------------------------------------------------------------
c     This routine subsamples field 1 into field 2 by trying to center |
c     horizontally.                                                    |
c                                                                      |
c     Calls:  none                                                     |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c        nx1....The number of x-grid points in field 1.                |
c        ny1....The number of y-grid points in field 1.                |
c        nz.....The number of model levels.                            |
c        fld1...The field to extract from.                             |
c        nx2....The number of x-grid points in field 2.                |
c        ny2....The number of y-grid points in field 2.                |
c                                                                      |
c     Output:                                                          |
c                                                                      |
c        fld2...The extracted field.                                   |
c-----------------------------------------------------------------------
c
      integer nx1,ny1,nz,nx2,ny2,i,j,k,ishift,jshift
      real    fld1(nz,nx1,ny1),fld2(nz,nx2,ny2)
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Compute shifts for centering small domain.                       |
c-----------------------------------------------------------------------
c
      ishift = (nx1-nx2)/2
      jshift = (ny1-ny2)/2
c
c-----------------------------------------------------------------------
c     Subsample larger domain onto smaller.                            |
c-----------------------------------------------------------------------
c
      do 10 k = 1, nz
         do 10 j = 1, ny2
            do 10 i = 1, nx2
               fld2(k,i,j) = fld1(k,i+ishift,j+jshift)
 10   continue
c
      return
      end
