      subroutine transunder (nx,ny,vals)
c
c-----------------------------------------------------------------------
c     This routine replaces values of the transport streamfunction     |
c     under the land mask with the values at the nearest boundary point|
c                                                                      |
c     Calls:  rinsert                                                  |
c                                                                      |
c     ------                                                           |
c     Input:                                                           |
c     ------                                                           |
c                                                                      |
c     nx........Number of points in x-direction.        (integer)      |
c     ny........Number of points in y-direction.        (integer)      |
c     vals......Initial values.                         (real array)   |
c                                                                      |
c     -------                                                          |
c     Output:                                                          |
c     -------                                                          |
c                                                                      |
c     vals......Values smoothly extended under mask.    (real array)   |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <fnparam.h>
#include <fncoast.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,j,m,n,nin,nx,ny
      logical error
      real    vals(nx,ny),wk(mxcsln)
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c  Choose median value along coast as constant value.
c-----------------------------------------------------------------------
c
      do 20 n = 1, ncst
         nin = 0
         do 10 m = 1, lencst(n)
            ip = m + (n-1)*mxlncs
            call rinsert (vals(icst(ip),jcst(ip)),wk,nin,mxcsln,error)
 10      continue
         ip = (nin+1)/2
         m = 1 + (n-1)*mxlncs
         if (mod(nin,2).ne.0) then
            vals(icst(m),jcst(m)) = wk(ip)
          else
            vals(icst(m),jcst(m)) = (wk(ip)+wk(ip+1))/2.0
         end if
 20   continue
c
c-----------------------------------------------------------------------
c  Set transport under mask & along coast to a constant.
c-----------------------------------------------------------------------
c
      do 30 j = 1, ny
      do 30 i = 1, nx
c
         ip = i + (j-1)*nx
         if (cmask(ip).gt.0) then
            m = 1 + (cmask(ip)-1)*mxlncs
            vals(i,j) = vals(icst(m),jcst(m))
         end if
c
 30   continue
c
      return
      end
