      subroutine wrt_fld (ncid,varname,filename,indx,nx,ny,nz,type,var)
c
c=======================================================================
c                                                                    ===
c  This routine writes a field variable to the given netCDF file.    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NCID.......NetCDF file identifier.             (integer)       ===
c     VARNAME....Variable name.                      (string)        ===
c     FILENAME...Name of NetCDF file.                (string)        ===
c     INDX.......Index of variable to write.         (integer)       ===
c     NX.........Number of x gridpoints.             (integer)       ===
c     NY.........Number of y gridpoints.             (integer)       ===
c     NZ.........Number of z gridpoints.             (integer)       ===
c                   (nz<0 flags a 2D field)                          ===
c     TYPE.......Flag and index for type of field.   (integer)       ===
c                  [<0]   barotropic field.                          ===
c                   [0]   scalar                                     ===
c                   [1]   zonal component  (or temp. pe_initial)     ===
c                   [2]   meridional component (or temp. pe_initial) ===
c                   [3]   other tracer  (pe_initial)                 ===
c     VAR........Extracted field variable.   (real array)            ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     LENGTH,  UDIEJOE                                               ===
c                                                                    ===
c     netCDF:  NCVPT,  NCVID                                         ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer err,indx,ncid,nx,ny,nz,sbn,sln,snd,type,varid,vbn,vln,vnd
      integer count(5),start(5)
      real          var(nx,ny,nz)
      character*(*) varname,filename
c
      save start,count
c
      data start,count /10*1/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Get variable identifier.
c-----------------------------------------------------------------------
c
      call length (varname,vln,vbn,vnd)
      varid = ncvid (ncid,varname(vbn:vnd),err)
c
      if (err.ne.0) then
         call length (filename,sln,sbn,snd)
         write (6,10) varname(vbn:vnd),filename(sbn:snd)
         call udiejoe ('WRT_FLD')
      end if
c
c-----------------------------------------------------------------------
c  Write variable.
c-----------------------------------------------------------------------
c
      start(1) = type
      start(5) = indx
      count(2) = nz
      count(3) = nx
      count(4) = ny
c
      if (type.gt.0) then
         call ncvpt (ncid,varid,start,count,var,err)
        else if (type.lt.0) then
         call ncvpt (ncid,varid,start(3),count(3),var,err)
        else
         call ncvpt (ncid,varid,start(2),count(2),var,err)
      end if
c
      if (err.ne.0) then
         call length (filename,sln,sbn,snd)
         write (6,20) varname(vbn:vnd),filename(sbn:snd)
         call udiejoe ('WRT_FLD')
      end if
c
      return
c
 10   format (/'*** Error:  WRT_FLD - unable to find variable ',
     &                              1h",a,1h",' in file:'/12x,1h",a,1h")
 20   format (/'*** Error:  WRT_FLD - unable to write variable ',
     &                              1h",a,1h",' to file:'/12x,1h",a,1h")
c
      end
