function status = def_fld (ncid,name,ncname,dimids,longname,units, ...
                           shortname,posn,ismask,spval);
%
%function status = def_fld (ncid,name,ncname,dimids,type,longname,units, ...
%                           shortname,posn,ismask,spval);
%
% This function defines a single field variable in a netCDF file.
%
% ------
% Input:
% ------
%
%    NCID........NetCDF identifier for output file.
%    NAME........Variable name.
%    NCNAME......File name.
%    DIMIDS......Dimensions for variable.
%    LONGNAME....Variable long descriptive name.
%    UNITS.......Variable units.
%    SHORTNAME...Variable short descriptive name.
%    POSN........Variable positions.
%    ISMASK......Mask flag.
%    SPVAL.......Fill/missing value.
%
% -------
% Output:
% -------
%
%    STATUS......Exit status.

ncid{name} = ncfloat(dimids);
if isempty(ncid{name}),
   disp (' ');
   disp (['***Error:  DEF_FLD - unable to define variable ',setstr(34), ...
                                          name,setstr(34),' in file:']);
   disp (['           ',setstr(34),ncname,setstr(34),'.']);
   disp (' ');
   status = [];
   return;
end;

attname = 'long_name';
attval  = longname;
eval(['ncid{name}.',attname,' = ncchar(attval);']);
eval(['status = isempty(ncid{name}.',attname,');']);
if (status),
   disp (' ');
   disp (['***Error:  DEF_FLD - unable to define variable ',setstr(34), ...
                             name,':',attname,setstr(34),' in file:']);
   disp (['           ',setstr(34),ncname,setstr(34),'.']);
   disp (' ');
   return;
end;

attname = 'units';
attval  = units;
eval(['ncid{name}.',attname,' = ncchar(attval);']);
eval(['status = isempty(ncid{name}.',attname,');']);
if (status),
   disp (' ');
   disp (['***Error:  DEF_FLD - unable to define variable ',setstr(34), ...
                             name,':',attname,setstr(34),' in file:']);
   disp (['           ',setstr(34),ncname,setstr(34),'.']);
   disp (' ');
   return;
end;

attname = 'field';
attval  = [shortname,', scalar, series'];
eval(['ncid{name}.',attname,' = ncchar(attval);']);
eval(['status = isempty(ncid{name}.',attname,');']);
if (status),
   disp (' ');
   disp (['***Error:  DEF_FLD - unable to define variable ',setstr(34), ...
                             name,':',attname,setstr(34),' in file:']);
   disp (['           ',setstr(34),ncname,setstr(34),'.']);
   disp (' ');
   return;
end;

attname = 'positions';
attval  = posn;
eval(['ncid{name}.',attname,' = ncchar(attval);']);
eval(['status = isempty(ncid{name}.',attname,');']);
if (status),
   disp (' ');
   disp (['***Error:  DEF_FLD - unable to define variable ',setstr(34), ...
                             name,':',attname,setstr(34),' in file:']);
   disp (['           ',setstr(34),ncname,setstr(34),'.']);
   disp (' ');
   return;
end;

if (ismask)
   attname = 'mask';
   attval  = 'mask';
   eval(['ncid{name}.',attname,' = ncchar(attval);']);
   eval(['status = isempty(ncid{name}.',attname,');']);
   if (status),
      disp (' ');
      disp (['***Error:  DEF_FLD - unable to define variable ',setstr(34), ...
                             name,':',attname,setstr(34),' in file:']);
      disp (['           ',setstr(34),ncname,setstr(34),'.']);
      disp (' ');
      return;
   end;
end;

attname = 'missing_value';
attval  = spval;
eval(['ncid{name}.',attname,' = ncfloat(attval);']);
eval(['status = isempty(ncid{name}.',attname,');']);
if (status),
   disp (' ');
   disp (['***Error:  DEF_FLD - unable to define variable ',setstr(34), ...
                             name,':',attname,setstr(34),' in file:']);
   disp (['           ',setstr(34),ncname,setstr(34),'.']);
   disp (' ');
   return;
end;

attname = 'FillValue_';
attval  = spval;
eval(['ncid{name}.',attname,' = ncfloat(attval);']);
eval(['status = isempty(ncid{name}.',attname,');']);
if (status),
   disp (' ');
   disp (['***Error:  DEF_FLD - unable to define variable ',setstr(34), ...
                             name,':',attname,setstr(34),' in file:']);
   disp (['           ',setstr(34),ncname,setstr(34),'.']);
   disp (' ');
   return;
end;
