function status = def_flds (ncid,name,ncname,dimids,dims2,longname,units, ...
                            shortname,hgrnme,ismask,spval);
%
%function status = def_flds (ncid,name,ncname,dimids,type,longname,units, ...
%                            shortname,ismask,spval);
%
% This function defines a multiple field variable in a netCDF file.
%
% ------
% Input:
% ------
%
%    NCID........NetCDF identifier for output file.
%    NAME........Variable name.
%    NCNAME......File name.
%    DIMIDS......Dimensions for variable.
%    LONGNAME....Variable long descriptive name.
%    UNITS.......Variable units.
%    SHORTNAME...Variable short descriptive name.
%    HGRNME......Horizontal grid name.
%    ISMASK......Mask flag.
%    SPVAL.......Fill/missing value.
%
% -------
% Output:
% -------
%
%    STATUS......Exit status.

grid = [hgrnme,', product; zout, product'];

%--------------------------
%--- Define base field. ---
%--------------------------

status = def_fld (ncid,name,ncname,dimids,longname,units, ...
                  shortname,grid,ismask,spval);

if isempty(status),
   disp (' ');
   disp (['***Error:  DEF_FLDS - unable to define variable ',setstr(34), ...
                                          name,setstr(34),' in file:']);
   disp (['           ',setstr(34),ncname,setstr(34),'.']);
   disp (' ');
   return;
end;

%---------------------------
%--- Define error field. ---
%---------------------------

status = def_fld (ncid,[name,'err'],ncname,dimids, ...
                  ['observation error, ',longname],units, ...
                  ['error ',shortname], ...
                  grid,ismask,spval);

if isempty(status),
   disp (' ');
   disp (['***Error:  DEF_FLDS - unable to define variable ',setstr(34), ...
                                  [name,'err'],setstr(34),' in file:']);
   disp (['           ',setstr(34),ncname,setstr(34),'.']);
   disp (' ');
   return;
end;

%---------------------------------
%--- Define error-scale field. ---
%---------------------------------

status = def_fld (ncid,[name,'rmsdev'],ncname,dims2, ...
                  ['RMS deviation from mean, ',longname],units, ...
                  ['RMS ',shortname], ...
                  'zout',0,spval);

if isempty(status),
   disp (' ');
   disp (['***Error:  DEF_FLDS - unable to define variable ',setstr(34), ...
                                  [name,'rmsdev'],setstr(34),' in file:']);
   disp (['           ',setstr(34),ncname,setstr(34),'.']);
   disp (' ');
   return;
end;
