function [dzv,zv] = get_depths (gfile);
%
% function [dzv,zv] = get_depths (gfile);
%
% This function gets the thicknesse from the GRIDS netCDF file and
% constructs the vertical coordinate system.

%-------------------------------------------------------------------------------
% Initialize output.
%-------------------------------------------------------------------------------

dzv = [];
zv  = [];

%-------------------------------------------------------------------------------
% Open GRIDS netCDF file.
%-------------------------------------------------------------------------------

ncid = netcdf(gfile);

if isempty(ncid)
   disp (' ');
   disp ('***Error:  GET_DEPTHS - unable to open file:');
   disp (['           ',setstr(34),gfile,setstr(34)]);
   disp (' ');
   return
end;

%-------------------------------------------------------------------------------
% Read thicknesses.
%-------------------------------------------------------------------------------

name = 'dzv';
dzv  = ncid{name}(:);

if isempty(dzv)
   disp (' ');
   disp (['***Error:  GET_DEPTHS - unable to read ',setstr(34), ...
           name,setstr(34),' in file:']);
   disp (['           ',setstr(34),gfile,setstr(34)]);
   disp (' ');
   return
end;

%-------------------------------------------------------------------------------
% Close GRIDS netCDF file.
%-------------------------------------------------------------------------------

status = close(ncid);

if ~isempty(status)
   disp (' ');
   disp ('***Error:  GET_DEPTHS - unable to close file:');
   disp (['           ',setstr(34),gfile,setstr(34)]);
   disp (' ');
   return
end;

%-------------------------------------------------------------------------------
% Construct depths.
%-------------------------------------------------------------------------------

[ny nx nz] = size(dzv);

zv = zeros(ny,nx,nz);

zv(:,:,1) = dzv(:,:,1)./2;

for k = 2:nz
   km1 = k - 1;
   zv(:,:,k) = zv(:,:,km1) + 0.5.*(dzv(:,:,km1)+dzv(:,:,k));
end;
