function [dim,status] = get_dim (ncid,name);
%
% function [dim,status] = get_dim (ncid,name);
%
% This function gets the size of the requested dimension from a netCDF file.
%
% ------
% Input:
% ------
%
%    ncid.....Identifier for open netCDF file
%    name.....Name of dimension in netCDF file.
%
% -------
% Output:
% -------
%
%    dim......Size of requested dimension.
%    status...Exit status.

%-------------------------------------------------------------------------------
% Get identifier for dimension.
%-------------------------------------------------------------------------------

dimid = mexcdf ('ncdimid',ncid,name);

if (dimid<0),
   disp(' ');
   disp([setstr(7),'***Error:  GET_DIM - unable to find dimension ', ...
                             setstr(34),name,setstr(34),setstr(7)]);
   disp(' ');
   status = dimid;
   return;
end;

%-------------------------------------------------------------------------------
% Get size for requested dimension.
%-------------------------------------------------------------------------------

[dum,dim,status] = mexcdf ('ncdiminq',ncid,dimid);

if (status<0),
   disp(' ');
   disp([setstr(7),'***Error:  GET_DIM - unable to read dimension ', ...
                             setstr(34),name,setstr(34),setstr(7)]);
   disp(' ');
   return;
end;
