function [value,status] = get_var (ncid,name,index,count);
%
% function [value,status] = get_var (ncid,name,index,count);
%
% This function gets the requested values from a netCDF file.
%
% ------
% Input:
% ------
%
%    ncid.....Identifier for open netCDF file
%    name.....Name of variable in netCDF file.
%    index....Index (possibly multidimensional) of value to extract
%    count....Number of values to extract (along each dimension).
%
% -------
% Output:
% -------
%
%    value....Extracted value.
%    status...Exit status.

%-------------------------------------------------------------------------------
% Get identifier for variable.
%-------------------------------------------------------------------------------

varid = mexcdf ('ncvarid',ncid,name);

if (varid<0),
   disp(' ');
   disp([setstr(7),'***Error:  GET_VAR - unable to find variable ', ...
                             setstr(34),name,setstr(34),setstr(7)]);
   disp(' ');
   status = varid;
   return;
end;

%-------------------------------------------------------------------------------
% Get requested value for variable.
%-------------------------------------------------------------------------------

[value,status] = mexcdf ('ncvarget',ncid,varid,index,count);

if (status<0),
   disp(' ');
   disp([setstr(7),'***Error:  GET_VAR - unable to read variable ', ...
                             setstr(34),name,setstr(34),setstr(7)]);
   disp(' ');
   return;
end;
