function [value,status] = get_var1 (ncid,name,index);
%
% function [value,status] = get_var1 (ncid,name,index);
%
% This function gets the requested single value from a netCDF file.
%
% ------
% Input:
% ------
%
%    ncid.....Identifier for open netCDF file
%    name.....Name of variable in netCDF file.
%    index....Index (possibly multidimensional) of value to extract
%
% -------
% Output:
% -------
%
%    value....Extracted value.
%    status...Exit status.

%-------------------------------------------------------------------------------
% Get identifier for variable.
%-------------------------------------------------------------------------------

varid = mexcdf ('ncvarid',ncid,name);

if (varid<0),
   disp(' ');
   disp([setstr(7),'***Error:  GET_VAR1 - unable to find variable ', ...
                             setstr(34),name,setstr(34),setstr(7)]);
   disp(' ');
   status = varid;
   return;
end;

%-------------------------------------------------------------------------------
% Get requested value for variable.
%-------------------------------------------------------------------------------

[value,status] = mexcdf ('ncvarget1',ncid,varid,index);

if (status<0),
   disp(' ');
   disp([setstr(7),'***Error:  GET_VAR1 - unable to read variable ', ...
                             setstr(34),name,setstr(34),setstr(7)]);
   disp(' ');
   return;
end;
