function hms_toc;
%
% function hms_toc;
%
% Hour, Minute, Second TOC
%
% This function reports the elapsed time
% in a more convient form.

t = toc;

hr = fix (t/3600);

mn = fix ( rem(t,3600)/60 );

sc = rem (t,60);

if (sc<10)
   tstr = [num2str(hr),':',num2str(mn,'%2.2d'),':0',num2str(sc)];
 else
   tstr = [num2str(hr),':',num2str(mn,'%2.2d'),':',num2str(sc)];
end;

disp (['   Elapsed time:  ',tstr]);
