% icon2hops
%
% This script combines 2 interpolated ICON output files into 1 HOPS OA(G)/FM
% type file.

%-------------------------------------------------------------------------------
% Get run parameters.
%-------------------------------------------------------------------------------

infiledef = 'icon2hops.in';

infile = input(['Enter name of input file [',infiledef,']: '],'s');
if isempty(infile)
   infile = infiledef;
end;

clear infiledef;

[run_parm,run_file,time,status] = icon2hops_inparm (infile);

if (status<0)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to read input file:');
   disp (['           ',setstr(34),infile,setstr(34)]);
   disp (' ');
   return;
end;

clear infile;

%-------------------------------------------------------------------------------
% Open ICON input files.
%-------------------------------------------------------------------------------

ind   = find(abs(run_file(1,:))~=0);
dpname = run_file(1,ind);
ncdp = netcdf (dpname);
if isempty(ncdp)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to open input file:');
   disp (['           ',setstr(34),dpname,setstr(34)]);
   disp (' ');
   return;
end;

ind   = find(abs(run_file(2,:))~=0);
shname = run_file(2,ind);
ncsh = netcdf (shname);
if isempty(ncsh)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to open input file:');
   disp (['           ',setstr(34),shname,setstr(34)]);
   disp (' ');
   return;
end;

%-------------------------------------------------------------------------------
% Get ICON positions & times.
%-------------------------------------------------------------------------------

name = 'grid2';
lon = squeeze(ncdp{name}(:,:,1));
if isempty(lon)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to read input file:');
   disp (['           ',setstr(34),dpname,setstr(34)]);
   disp (' ');
   return;
end;
lat = squeeze(ncdp{name}(:,:,2));
if isempty(lat)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to read input file:');
   disp (['           ',setstr(34),dpname,setstr(34)]);
   disp (' ');
   return;
end;

name = 'time';
intime = ncdp{name}(:);
if isempty(intime)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to read input file:');
   disp (['           ',setstr(34),dpname,setstr(34)]);
   disp (' ');
   return;
end;

name = 'zout';
zdp = ncdp{name}(:);
if isempty(zdp)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to read input file:');
   disp (['           ',setstr(34),dpname,setstr(34)]);
   disp (' ');
   return;
end;
zsh = ncsh{name}(:);
if isempty(zsh)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to read input file:');
   disp (['           ',setstr(34),shname,setstr(34)]);
   disp (' ');
   return;
end;

%-------------------------------------------------------------------------------
% Create output file.
%-------------------------------------------------------------------------------

[ncid,tlon,tlat,vlon,vlat,zout] = defcdf (run_file,run_parm,ncdp,ncsh);

if isempty(ncid)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to create output file:');
   disp (['           ',setstr(34),run_file(4,:),setstr(34)]);
   disp (' ');
   return;
end;

%-------------------------------------------------------------------------------
% Get velocity rotation angle.
%-------------------------------------------------------------------------------

ind   = find(abs(run_file(3,:))~=0);
gname = run_file(3,ind);
ncg = netcdf (gname);
if isempty(ncg)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to open input file:');
   disp (['           ',setstr(34),gname,setstr(34)]);
   disp (' ');
   return;
end;

name = 'lrotang';
phi = (ncg{name}(:)).*(pi/180);
if isempty(phi)
   disp (' ');
   disp (['***Error:  ICON2HOPS - unable to read ',setstr(34), ...
          name,setstr(34),' in input file:']);
   disp (['           ',setstr(34),gname,setstr(34)]);
   disp (' ');
   return;
end;

status = close(ncg);
if ~isempty(status)
   disp (' ');
   disp ('***Error:  ICON2HOPS - unable to close input file:');
   disp (['           ',setstr(34),gname,setstr(34)]);
   disp (' ');
   return;
end;

clear gname ind ncg status;

cosp = cos(phi);
sinp = sin(phi);

clear phi;

%-------------------------------------------------------------------------------
% Interpolate data.
%-------------------------------------------------------------------------------

ann_tic ('Interpolating data');

for n = 1:length(time);

   dt = abs(intime-time(n));
   tind = min(find(dt==min(dt)));
   disp(['   time:  ',num2str(time(n))]);
   ncid{'time'}(n) = intime(tind);

   %------------------
   %--- Deep file. ---
   %------------------

   for k = 1:length(zdp);

      dz = abs(zout-zdp(k));
      zind = min(find(dz==min(dz)));
      disp(['      depth:  ',num2str(zdp(k))]);

      name = 'temp';
      disp(['         ',name]);
      [fld,fstd,err] = intfld (ncdp,name,tind,k,1,run_parm,lat,lon,tlat,tlon);
      status = wrtfld (ncid,name,n,zind,1,fld,fstd,err);
      name = 'salt';
      disp(['         ',name]);
      [fld,fstd,err] = intfld (ncdp,name,tind,k,1,run_parm,lat,lon,tlat,tlon);
      status = wrtfld (ncid,name,n,zind,1,fld,fstd,err);
      name = 'vtot';
      disp(['         ',name]);
      [fld,fstd,err] = intfld (ncdp,name,tind,k,1,run_parm,lat,lon,vlat,vlon);
      [fld2,fstd,err] = intfld (ncdp,name,tind,k,2,run_parm,lat,lon,vlat,vlon);
      if (~isempty(fld) & ~isempty(fld2))
         u = fld.*cosp + fld2.*sinp;
         v = fld2.*cosp - fld.*sinp;
      else
         u = [];
         v = [];
      end;
      status = wrtfld (ncid,name,n,zind,1,u,fstd,err);
      status = wrtfld (ncid,name,n,zind,2,v,fstd,err);

   end;

   %---------------------
   %--- Shallow file. ---
   %---------------------

   for k = 1:length(zsh);

      dz = abs(zout-zsh(k));
      zind = min(find(dz==min(dz)));
      disp(['      depth:  ',num2str(zsh(k))]);

      name = 'temp';
      disp(['         ',name]);
      [fld,fstd,err] = intfld (ncsh,name,tind,k,1,run_parm,lat,lon,tlat,tlon);
      status = wrtfld (ncid,name,n,zind,1,fld,fstd,err);
      name = 'salt';
      disp(['         ',name]);
      [fld,fstd,err] = intfld (ncsh,name,tind,k,1,run_parm,lat,lon,tlat,tlon);
      status = wrtfld (ncid,name,n,zind,1,fld,fstd,err);
      name = 'vtot';
      disp(['         ',name]);
      [fld,fstd,err] = intfld (ncsh,name,tind,k,1,run_parm,lat,lon,vlat,vlon);
      [fld2,fstd,err] = intfld (ncsh,name,tind,k,2,run_parm,lat,lon,vlat,vlon);
      if (~isempty(fld) & ~isempty(fld2))
         u = fld.*cosp + fld2.*sinp;
         v = fld2.*cosp - fld.*sinp;
      else
         u = [];
         v = [];
      end;
      status = wrtfld (ncid,name,n,zind,1,u,fstd,err);
      status = wrtfld (ncid,name,n,zind,2,v,fstd,err);

   end;
   status = sync(ncid);
end;

hms_toc;

close (ncid);
close (ncdp);
close (ncsh);
