function [run_parm,run_file,time,status] = icon2hops_inparm (infile);
%
% function [run_parm,run_file,time,status] = icon2hops_inparm (infile);
%
% This function reads the parameters needed to drive the ShelfBreak Front
% Feature Model and packs most of them into a pair of matrices.
%
% ------
% Input:
% ------
%
%    INFILE     Parameter input file.
%
% -------
% Output:
% -------
%
%    RUN_PARM   Numerical parameters driving the SBF FM.
%                  RUN_PARM( 1) - EMIN     Minimum relative error.
%                  RUN_PARM( 2) - ETRANS   Error transition width.
%    RUN_FILE   Input/Output file names for the SBF FM
%                  RUN_FILE(1,:) - DEEP_FILE      Deep ICON netCDF file.
%                  RUN_FILE(2,:) - SHALLOW_FILE   Shallow ICON netCDF file.
%                  RUN_FILE(3,:) - GRID_FILE      GRIDS netCDF file.
%                  RUN_FILE(4,:) - OUT_FILE       Output netCDF file, (melded).
%    TIME       Time level(s) to extract data from OA files.
%    STATUS     Exit status.  [<0] error  [other] O.K.

%-------------------------------------------------------------------------------
% Initialize output.
%-------------------------------------------------------------------------------

run_parm = [];
time     = [];
run_file = '';

%-------------------------------------------------------------------------------
%  Open input file.
%-------------------------------------------------------------------------------

[fid,mess] = fopen (infile,'r');

if (fid<0)
   disp (' ');
   disp ('***Error:  ICON2HOPS_INPARM - unable to open input file:');
   disp (['           ',setstr(34),infile,setstr(34)]);
   disp (['           ',setstr(34),mess,setstr(34)]);
   disp (' ');
   status = fid;
   return;
end;

%-------------------------------------------------------------------------------
% Read input ASCII file.
%-------------------------------------------------------------------------------

jdst   = num_read (fid);
jdnd   = num_read (fid);
tskip  = num_read (fid);
emin   = num_read (fid);
etrans = num_read (fid);

deep_file    = fgetl (fid);
shallow_file = fgetl (fid);
grid_file    = fgetl (fid);
out_file     = fgetl (fid);

%-------------------------------------------------------------------------------
% Close input ASCII file.
%-------------------------------------------------------------------------------

status = fclose (fid);

if (status<0)
   disp (' ');
   disp ('***Error:  ICON2HOPS_INPARM - unable to close input file:');
   disp (['           ',setstr(34),infile,setstr(34)]);
   disp (' ');
   return;
end;

%-------------------------------------------------------------------------------
% Pack input parameters & file names.
%-------------------------------------------------------------------------------

run_file(1,1:length(deep_file))    = deep_file;
run_file(2,1:length(shallow_file)) = shallow_file;
run_file(3,1:length(grid_file))    = grid_file;
run_file(4,1:length(out_file))     = out_file;

clear deep_file shallow_file grid_file out_file;

run_parm = [emin etrans];

time = jdst:tskip:jdnd;

clear emin etrans jdst tskip jdnd;
