function [fld,fstd,err] = intfld (ncid,name,tind,zind,vind,run_parm, ...
                                  ilat,ilon,hlat,hlon);
%
% function [fld,fstd,err] = intfld (ncid,name,tind,zind,vind,run_parm, ...
%                                   ilat,ilon,hlat,hlon);
%
% This function reads in the requested ICON field and interpolates it to the
% HOPS horizontal grid.

emin = run_parm(1);
etrans = run_parm(2);

%-------------------------------------------------------------------------------
% Read data.
%-------------------------------------------------------------------------------

isvec = length(size(ncid{name})) > 4;

if ~isvec
   ifld = squeeze(ncid{name}(tind,:,:,zind));
 else
   ifld = squeeze(ncid{name}(tind,:,:,zind,vind));
end;

fval = ncid{name}.FillValue_(:);

%-------------------------------------------------------------------------------
% Flag missing values.
%-------------------------------------------------------------------------------

ind = find (ifld==fval);

if ~isempty(ind)
   ifld(ind) = NaN;
end;

%-------------------------------------------------------------------------------
% Fill-in flagged values or flag entire field.
%-------------------------------------------------------------------------------

if any(~isnan(ifld(:)))
   msk = ones(size(ifld));
   ind = find(isnan(ifld));
   if ~isempty(ind)
      msk(ind) = 0;
      wk = ifld;
      ifld = smooth_under_iw (wk,msk);
      clear wk;
   end;
   fld = griddata (ilon,ilat,ifld,hlon,hlat);
   err = griddata (ilon,ilat,msk,hlon,hlat);
   ind = find(isnan(fld));
   if ~isempty(ind)
      msk = ones(size(fld));
      msk(ind) = 0;
      wk = fld;
      fld = smooth_under_iw (wk,msk);
      clear wk;
   end;
   ind = find(isnan(err));
   if ~isempty(ind)
      err(ind) = 0;
   end;
   if (etrans>0)
      msk = ones(size(err));
      ind = find(err<0.5);
      if ~isempty(ind)
         msk(ind) = 0;
         [ny nx] = size(err);
         n = [2:ny ny];
         s = 1:ny;
         e = [2:nx nx];
         w = 1:nx;
         mskold = msk;
         for j = 1:round(etrans)
            msk = msk(n,w).*msk(n,:).*msk(n,e).* ...
                  msk(:,w).*msk.*msk(:,e).* ...
                  msk(s,w).*msk(s,:).*msk(s,e);
         end;
         msk = mskold-msk;
         msk = 1 - msk;
         clear mskold;
         wk=err;
         err = smooth_under_iw(wk,msk);
      end;
   end;
   df = fld(:)-mean(fld(:));
   fstd = sqrt(mean(df.*df).*length(fld)./(length(fld)-1));
   err = emin.*err + (1-err);
   err = sqrt(err).*fstd;
 else
   fld = [];
   fstd = [];
   err = [];
end;
