      subroutine p2pber (psierr,pberr)
c
c=======================================================================
c                                                                    ===
c  This routine constructs a transport streamfunction error field by ===
c  vertically averaging the streamfunction error field.              ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     PSIERR   Streamfunction error field.             (real array)  ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /HYBRID/                                                          ===
c                                                                    ===
c     DZT   Thicknesses over T-grid.       (real array; cm)          ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c     IM   number of points in the x-direction.  (integer)           ===
c     JM   number of points in the y-direction.  (integer)           ===
c     KM   number of points in the z-direction.  (integer)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     PBERR   Transport streamfunction error field.    (real array)  ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <hybrid.h>
#include <ndimen.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ip,k
      real    dztot
      real pberr(np),psierr(np,nz)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 20 ip = 1, im*jm
         pberr(ip) = psierr(ip,1)*dzt(ip,1)
         dztot     = dzt(ip,1)
         do 10 k = 2, km
            pberr(ip) = pberr(ip) + psierr(ip,k)*dzt(ip,k)
            dztot     = dztot + dzt(ip,k)
  10     continue
         pberr(ip) = pberr(ip)/dztot
  20  continue
c
      return
      end
