function fnew = smooth_under_iw (f,msk);
%
% function fnew = smooth_under_iw (f,msk);
%
% This function smoothly extrapolates the given
% field under its mask.

%-------------------------------------------------------------------------------
% By-pass this entirely, if no bad points exist.
%-------------------------------------------------------------------------------

if isempty(find(msk==0))
   fnew = f;
   return;
end;

%-------------------------------------------------------------------------------
% Initialize with identity matrix.
%-------------------------------------------------------------------------------

[ny nx] = size (f);

rhs = reshape (f,nx*ny,1);

diag0     = ones (nx*ny,1);

diagp1    = zeros (nx*ny,1);
diagpnym1 = zeros (nx*ny,1);
diagpny   = zeros (nx*ny,1);
diagpnyp1 = zeros (nx*ny,1);

diagm1    = zeros (nx*ny,1);
diagmnyp1 = zeros (nx*ny,1);
diagmny   = zeros (nx*ny,1);
diagmnym1 = zeros (nx*ny,1);

%-------------------------------------------------------------------------------
% Find bad values.  Clear right-hand side under mask.
%-------------------------------------------------------------------------------

[jbad ibad] = find (msk==0);

indbad = jbad + (ibad-1).*ny;

rhs(indbad) = 0;

clear indbad;

%-------------------------------------------------------------------------------
% Set Averaging operator under mask.
%-------------------------------------------------------------------------------

%-----------------
%--- SW corner ---
%-----------------

ind = find ((jbad==1) & (ibad==1));

if ~isempty(ind)
   indwk = jbad(ind) + (ibad(ind)-1)*ny;
   diag0(indwk)          = -0.75;
   diagp1(indwk+1)       = 0.25;
   diagpny(indwk+ny)     = 0.25;
   diagpnyp1(indwk+ny+1) = 0.25;
   jbad(ind) = [];
   ibad(ind) = [];
end;

%-----------------
%--- SE corner ---
%-----------------

ind = find ((jbad==1) & (ibad==nx));

if ~isempty(ind)
   indwk = jbad(ind) + (ibad(ind)-1)*ny;
   diag0(indwk)          = -0.75;
   diagp1(indwk+1)       = 0.25;
   diagmny(indwk-ny)     = 0.25;
   diagmnyp1(indwk-ny+1) = 0.25;
   jbad(ind) = [];
   ibad(ind) = [];
end;

%-----------------
%--- NW corner ---
%-----------------

ind = find ((jbad==ny) & (ibad==1));

if ~isempty(ind)
   indwk = jbad(ind) + (ibad(ind)-1)*ny;
   diag0(indwk)          = -0.75;
   diagm1(indwk-1)       = 0.25;
   diagpny(indwk+ny)     = 0.25;
   diagpnym1(indwk+ny-1) = 0.25;
   jbad(ind) = [];
   ibad(ind) = [];
end;

%-----------------
%--- NE corner ---
%-----------------

ind = find ((jbad==ny) & (ibad==nx));

if ~isempty(ind)
   indwk = jbad(ind) + (ibad(ind)-1)*ny;
   diag0(indwk)          = -0.75;
   diagm1(indwk-1)       = 0.25;
   diagmny(indwk-ny)     = 0.25;
   diagmnym1(indwk-ny-1) = 0.25;
   jbad(ind) = [];
   ibad(ind) = [];
end;

%--------------
%--- W edge ---
%--------------

ind = find ((ibad==1));

if ~isempty(ind)
   indwk = jbad(ind) + (ibad(ind)-1)*ny;
   diag0(indwk)          = -0.75;
   diagm1(indwk-1)       = 0.125;
   diagp1(indwk+1)       = 0.125;
   diagpny(indwk+ny)     = 0.25;
   diagpnym1(indwk+ny-1) = 0.125;
   diagpnyp1(indwk+ny+1) = 0.125;
   jbad(ind) = [];
   ibad(ind) = [];
end;

%--------------
%--- E edge ---
%--------------

ind = find ((ibad==nx));

if ~isempty(ind)
   indwk = jbad(ind) + (ibad(ind)-1)*ny;
   diag0(indwk)          = -0.75;
   diagm1(indwk-1)       = 0.125;
   diagp1(indwk+1)       = 0.125;
   diagmny(indwk-ny)     = 0.25;
   diagmnym1(indwk-ny-1) = 0.125;
   diagmnyp1(indwk-ny+1) = 0.125;
   jbad(ind) = [];
   ibad(ind) = [];
end;

%--------------
%--- S edge ---
%--------------

ind = find ((jbad==1));

if ~isempty(ind)
   indwk = jbad(ind) + (ibad(ind)-1)*ny;
   diag0(indwk)          = -0.75;
   diagp1(indwk+1)       = 0.25;
   diagmny(indwk-ny)     = 0.125;
   diagpny(indwk+ny)     = 0.125;
   diagmnyp1(indwk-ny+1) = 0.125;
   diagpnyp1(indwk+ny+1) = 0.125;
   jbad(ind) = [];
   ibad(ind) = [];
end;

%--------------
%--- N edge ---
%--------------

ind = find ((jbad==ny));

if ~isempty(ind)
   indwk = jbad(ind) + (ibad(ind)-1)*ny;
   diag0(indwk)          = -0.75;
   diagm1(indwk-1)       = 0.25;
   diagmny(indwk-ny)     = 0.125;
   diagpny(indwk+ny)     = 0.125;
   diagmnym1(indwk-ny-1) = 0.125;
   diagpnym1(indwk+ny-1) = 0.125;
   jbad(ind) = [];
   ibad(ind) = [];
end;

%----------------
%--- Interior ---
%----------------

indwk = jbad + (ibad-1)*ny;
diag0(indwk)          = -0.75;
diagm1(indwk-1)       = 0.125;
diagp1(indwk+1)       = 0.125;
diagmny(indwk-ny)     = 0.125;
diagpny(indwk+ny)     = 0.125;
diagmnym1(indwk-ny-1) = 0.0625;
diagpnym1(indwk+ny-1) = 0.0625;
diagmnyp1(indwk-ny+1) = 0.0625;
diagpnyp1(indwk+ny+1) = 0.0625;

clear ind indwk ibad jbad;

%-------------------------------------------------------------------------------
% Solve extrapolation problem.
%-------------------------------------------------------------------------------

%-------------------------------
%--- Assemble sparse matrix. ---
%-------------------------------

ExtMat = spdiags ( [diagmnym1 diagmny diagmnyp1 ...
                    diagm1    diag0   diagp1    ...
                    diagpnym1 diagpny diagpnyp1 ], ...
                   [(-ny-1):(1-ny) -1:1 (ny-1):(ny+1)], ...
                   (nx*ny), (nx*ny) );

clear diagmnym1 diagmny diagmnyp1 ...
      diagm1    diag0   diagp1    ...
      diagpnym1 diagpny diagpnyp1;

%------------------------------
%--- Solve matrix equation. ---
%------------------------------

soln = ExtMat\rhs;

%----------------------------------
%--- Put answer in useful form. ---
%----------------------------------

fnew = reshape (soln,ny,nx);
