function status = wrtfld (ncid,name,tind,zind,vind,fld,fstd,err);
%
% function status = wrtfld (ncid,name,tind,zind,vind,fld,fstd,err);
%
% This function writes the fields out.

status = [];

%-------------------------------------------------------------------------------
% If field was all flagged, get field above.
%-------------------------------------------------------------------------------

isvec = length(size(ncid{name})) > 4;

if isempty(fld)
   status = sync(ncid);
   if ~isvec
      fld = squeeze(ncid{name}(tind,:,:,(zind-1)));
      fstd = squeeze(ncid{[name,'rmsdev']}(tind,(zind-1)));
    else
      fld = squeeze(ncid{name}(tind,:,:,(zind-1),vind));
      fstd = squeeze(ncid{[name,'rmsdev']}(tind,(zind-1),vind));
   end;
   err = ones(size(fld)).*fstd;
end;

%-------------------------------------------------------------------------------
% Write fields.
%-------------------------------------------------------------------------------

if ~isvec
   ncid{name}(tind,:,:,zind) = fld;
   ncid{[name,'err']}(tind,:,:,zind) = err;
   ncid{[name,'rmsdev']}(tind,zind) = fstd;
 else
   ncid{name}(tind,:,:,zind,vind) = fld;
   ncid{[name,'err']}(tind,:,:,zind,vind) = err;
   ncid{[name,'rmsdev']}(tind,zind,vind) = fstd;
end;
