      subroutine cperr (inerr,nk,outerr)
c
c=======================================================================
c                                                                    ===
c  This routine copies one error field to another.                   ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     INERR    Original error field.       (real array)              ===
c     NK       Number of vertical levels.  (integer)                 ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c     IM   number of points in the x-direction.  (integer)           ===
c     JM   number of points in the y-direction.  (integer)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     OUTERR   Copy of error field.        (real array)              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <ndimen.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ip,k,nk
      real inerr(np,nk),outerr(np,nk)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 20 k = 1, nk
         do 10 ip = 1, im*jm
            outerr(ip,k) = inerr(ip,k)
  10     continue
  20  continue
c
      return
      end
