      subroutine errdef (errfld,nk,eval)
c
c=======================================================================
c                                                                    ===
c  This routine applies a default error value.                       ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NK       Number of vertical levels.  (integer)                 ===
c     EVAL     Default error value.        (real)                    ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c     IM   number of points in the x-direction.  (integer)           ===
c     JM   number of points in the y-direction.  (integer)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     ERRFLD   Bounded error field.        (real array)              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <ndimen.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ip,k,nk
      real    c0,c1,eval,ewk
      real errfld(np,nk)
c
      parameter (c0=0.0, c1=1.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      ewk = max(c0,min(c1,eval))
c
      do 20 k = 1, nk
         do 10 ip = 1, im*jm
            errfld(ip,k) = ewk
  10     continue
  20  continue
c
      return
      end
