function [errp,errt,errv] = set_err_out (gfile,thick,errmin,errmax);
%
% function [errp,errt,errv] = set_err_out (gfile,thick,errmin,errmax);
%
% This function creates an error mask with minimal errors
% at the outer boundary, and along the exterior coasts.
% Maximal errors away from these points with smooth transitions.

%-------------------------------------------------------------------------------
% Get coastal data.
%-------------------------------------------------------------------------------

[tbath,vbath,dxt,dyt,metxt,metyt,dxu,dyu,metxu,metyu, ...
          cenlat,cstmask,landv,lncst,icst,jcst,nisle,status] = ...
                                                          get_grids (gfile,0);

clear tbath vbath dxt dyt metxt metyt dxu dyu metxu metyu
clear cenlat landv status gfile

xtcstind = 1:(length(lncst)-nisle);

if (nisle>0),
   islind = (length(lncst)-nisle+1):length(lncst);
end;

%-------------------------------------------------------------------------------
% Create initial guess.
%-------------------------------------------------------------------------------

[bpdist,btdist,bvdist,bzdist] = bndy_dist (cstmask,lncst(xtcstind), ...
                                  icst(:,xtcstind),jcst(:,xtcstind),'Exterior');

wk = errmax.*ones(size(bpdist));
ind = find (bpdist==0);
wk(ind) = errmin;
msk = ones(size(bpdist));
ind = find ((bpdist>0) & (bpdist<thick));
msk(ind) = 0;
errp = smooth_under_iw (wk,msk);

wk = errmax.*ones(size(btdist));
ind = find (btdist==0);
wk(ind) = errmin;
msk = ones(size(btdist));
ind = find ((btdist>0) & (btdist<thick));
msk(ind) = 0;
errt = smooth_under_iw (wk,msk);

wk = errmax.*ones(size(bvdist));
ind = find (bvdist==0);
wk(ind) = errmin;
msk = ones(size(bvdist));
ind = find ((bvdist>0) & (bvdist<thick));
msk(ind) = 0;
errv = smooth_under_iw (wk,msk);
