function psinew = setisle (psi,islind,lncst,icst,jcst);
%
% function psinew = setisle (psi,islind,lncst,icst,jcst);
%
% This function sets the streamfunction around an island to a constant.
% That constant is simply the average of the streamfunction around the
% perimeter of the island.
%
% ------
% Input:
% ------
%
%    PSI......Original streamfunction.
%    LNCST....Length of island coastal segments.
%    ISLIND...Island indices.
%    ICST.....Island coastal segment i-indices.
%    JCST.....Island coastal segment j-indices.
%
% -------
% Output:
% -------
%
%    PSINEW...Modified streamfunction.

[ny nx]      = size(psi);
[mxcst ncst] = size(icst);

psinew = psi;

for n = 1:length(islind);

   iis = islind(n);
   ind = (1:lncst(iis)) + (iis-1).*mxcst;
   repind = jcst(ind) + (icst(ind)-1).*ny;

   psinew(repind) = mean(psinew(repind));

end;
