% trans_ass
%
% This script fudges an assimilation error field to assimilate transport
% streamfunction around coastal boundaries.

%-------------------------------------------------------------------------------
% Get name of input file containing run parameters.
%-------------------------------------------------------------------------------

parmfiledef = 'trans_ass.in';

parmfile = input (['Enter name of parameter input file [',parmfiledef, ...
                   ']: '],'s');
if isempty(parmfile)
   parmfile = parmfiledef;
end;

clear parmfiledef;

%-------------------------------------------------------------------------------
% Get run parameters.
%-------------------------------------------------------------------------------

ann_tic ('Reading input parameters');

[thick,gfile,ptmpl,pout,status] = tsass_parm (parmfile);

hms_toc;

if (status<0)
   disp (' ');
   disp ('***Error:  BNDY_ASS - unable to read parameter input file:');
   disp (['           ',setstr(34),parmfile,setstr(34)]);
   return;
end;

clear parmfile status;

%-------------------------------------------------------------------------------
% Construct error field.
%-------------------------------------------------------------------------------

ann_tic ('Setting Error mask');

[cstmask,lncst,icst,jcst,errmsk] = get_trans_dat (gfile,thick);

hms_toc;

clear gfile;

%-------------------------------------------------------------------------------
% Create assimilation file for boundary assimilation.
%-------------------------------------------------------------------------------

ann_tic ('Creating Transport Assimilation file');

eval (['!cp ',ptmpl,' ',pout]);

ncid = netcdf (pout,'write');

nt = length(ncid('time'));

for n = 1:nt

   ncid{'pbarerr'}(n,:,:) = set_trans_err (squeeze(ncid{'pbarerr'}(n,:,:)), ...
                                           errmsk,cstmask,lncst,icst,jcst);

end;

status = close (ncid);

hms_toc;
