function [thick,gfile,ptmpl,pout,status] = tsass_parm (parmfile);
%
% function [thick,gfile,ptmpl,pout,status] = tsass_parm (parmfile);
%
% This function reads in the parameters to run the "fake nest in OA" script.
%
% ------
% Input:
% ------
%
%    PARMFILE    Name of parameter input file.
%
% -------
% Output:
% -------
%
%    THICK    Thickness of assimilation zone.  (grid points)
%    GFILE    Name of GRIDS netCDF file.
%    PTMPL    Name of PE_initial netCDF template file.
%    POUT     Name of PE_initial netCDF output file.
%    STATUS   Exit status;

%-------------------------------------------------------------------------------
% Set default values.
%-------------------------------------------------------------------------------

thick  = [];
gfile  = '';
ptmpl  = '';
pout   = '';

%-------------------------------------------------------------------------------
% Open parameter input file.
%-------------------------------------------------------------------------------

[fid,mess] = fopen (parmfile,'r');

if (fid<0)
   disp (' ');
   disp ('***Error:  TSASS_PARM - unable to open parameter input file:');
   disp (['           ',setstr(34),parmfile,setstr(34)]);
   disp (['           ',setstr(34),mess,setstr(34)]);
   status = fid;
   return;
end;

%-------------------------------------------------------------------------------
% Read run parameters.
%-------------------------------------------------------------------------------

thick  = num_read (fid);
gfile  = fgetl (fid);
ptmpl  = fgetl (fid);
pout   = fgetl (fid);

%-------------------------------------------------------------------------------
% Close parameter input file.
%-------------------------------------------------------------------------------

status = fclose (fid);

if (status<0)
   disp (' ');
   disp ('***Error:  TSASS_PARM - unable to close parameter input file:');
   disp (['           ',setstr(34),parmfile,setstr(34)]);
end;
